/*
 * Decompiled with CFR 0.152.
 */
package com.nareshchocha.filepickerlibrary.picker;

import android.content.Context;
import android.net.Uri;
import androidx.activity.result.ActivityResultLauncher;
import androidx.activity.result.contract.ActivityResultContract;
import androidx.annotation.Keep;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.content.FileProvider;
import java.io.File;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import timber.log.Timber;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0016\u0010\b\u001a\u0004\u0018\u00010\t*\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0004H\u0007J\u0016\u0010\f\u001a\u0004\u0018\u00010\t*\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0004H\u0002JU\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u000e\"\u0004\b\u0000\u0010\u000f\"\u0004\b\u0001\u0010\u0010*\u00020\u00112\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u0002H\u000f\u0012\u0004\u0012\u0002H\u00100\u00132!\u0010\u0014\u001a\u001d\u0012\u0013\u0012\u0011H\u0010\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(\u0018\u0012\u0004\u0012\u00020\u00190\u0015H\u0007\u00a8\u0006\u001a"}, d2={"Lcom/nareshchocha/filepickerlibrary/picker/PickerUtils;", "", "()V", "createMediaFileFolder", "Ljava/io/File;", "folderFile", "fileName", "", "createFileGetUri", "Landroid/net/Uri;", "Landroid/content/Context;", "mFile", "getUriForFile", "selectFile", "Landroidx/activity/result/ActivityResultLauncher;", "I", "O", "Landroidx/appcompat/app/AppCompatActivity;", "contract", "Landroidx/activity/result/contract/ActivityResultContract;", "resultCallBack", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "result", "", "filepickerlibrary_release"})
public final class PickerUtils {
    @NotNull
    public static final PickerUtils INSTANCE = new PickerUtils();

    private PickerUtils() {
    }

    @Keep
    @NotNull
    public final <I, O> ActivityResultLauncher<I> selectFile(@NotNull AppCompatActivity $this$selectFile, @NotNull ActivityResultContract<I, O> contract, @NotNull Function1<? super O, Unit> resultCallBack) {
        Intrinsics.checkNotNullParameter((Object)$this$selectFile, (String)"<this>");
        Intrinsics.checkNotNullParameter(contract, (String)"contract");
        Intrinsics.checkNotNullParameter(resultCallBack, (String)"resultCallBack");
        ActivityResultLauncher activityResultLauncher = $this$selectFile.registerForActivityResult(contract, arg_0 -> PickerUtils.selectFile$lambda$0(resultCallBack, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)activityResultLauncher, (String)"registerForActivityResult(...)");
        return activityResultLauncher;
    }

    @Keep
    @NotNull
    public final File createMediaFileFolder(@NotNull File folderFile, @NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)folderFile, (String)"folderFile");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        if (!folderFile.exists() && !folderFile.mkdirs()) {
            Timber.Forest.tag("FILE_PICKER_ERROR ::").v("failed to create directory", new Object[0]);
        }
        return new File(folderFile.getPath() + File.separator + fileName);
    }

    @Keep
    @Nullable
    public final Uri createFileGetUri(@NotNull Context $this$createFileGetUri, @NotNull File mFile) {
        Uri uri;
        Intrinsics.checkNotNullParameter((Object)$this$createFileGetUri, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)mFile, (String)"mFile");
        if (!mFile.exists()) {
            try {
                mFile.createNewFile();
            }
            catch (IOException e) {
                Timber.Forest.tag("FILE_PICKER_ERROR ::").v(e.toString(), new Object[0]);
            }
            catch (SecurityException e) {
                Timber.Forest.tag("FILE_PICKER_ERROR ::").v(e.toString(), new Object[0]);
            }
        }
        Uri uri2 = this.getUriForFile($this$createFileGetUri, mFile);
        if (uri2 != null) {
            Uri uri3;
            Uri $this$createFileGetUri_u24lambda_u241 = uri3 = uri2;
            boolean bl = false;
            uri = uri3;
        } else {
            uri = null;
        }
        Uri uri4 = uri;
        return uri4;
    }

    private final Uri getUriForFile(Context $this$getUriForFile, File mFile) {
        return FileProvider.getUriForFile((Context)$this$getUriForFile.getApplicationContext(), (String)($this$getUriForFile.getApplicationContext().getPackageName() + ".library.fileprovider"), (File)mFile);
    }

    private static final void selectFile$lambda$0(Function1 $resultCallBack, Object result) {
        Intrinsics.checkNotNullParameter((Object)$resultCallBack, (String)"$resultCallBack");
        $resultCallBack.invoke(result);
    }
}

