/*
 * Decompiled with CFR 0.152.
 */
package io.github.changebooks.worksheet;

import com.google.common.base.Preconditions;
import java.io.File;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public enum WorksheetType {
    CSV,
    XLS;

    public static final String EXTENSION_CSV = "csv";
    public static final String EXTENSION_XLS = "xls";
    public static final String EXTENSION_XLSX = "xlsx";
    public static final String EXTENSION_SEPARATOR = ".";

    public static void checkSupport(WorksheetType type) {
        Preconditions.checkNotNull((Object)((Object)type), (Object)"type can't be null");
        boolean supported = CSV == type || XLS == type;
        Preconditions.checkArgument((boolean)supported, (Object)("unsupported's type: " + (Object)((Object)type)));
    }

    public static boolean isCsv(WorksheetType type) {
        if (Objects.isNull((Object)type)) {
            return false;
        }
        return CSV == type;
    }

    public static boolean isXls(WorksheetType type) {
        if (Objects.isNull((Object)type)) {
            return false;
        }
        return XLS == type;
    }

    public static WorksheetType fromFile(File file) {
        if (Objects.isNull(file)) {
            return null;
        }
        return WorksheetType.fromName(file.getName());
    }

    public static WorksheetType fromName(String fileName) {
        if (StringUtils.isEmpty((CharSequence)fileName)) {
            return null;
        }
        String fileExtension = WorksheetType.getExtension(fileName);
        if (StringUtils.isEmpty((CharSequence)fileExtension)) {
            return null;
        }
        return WorksheetType.fromExtension(fileExtension);
    }

    public static WorksheetType fromExtension(String fileExtension) {
        if (StringUtils.isEmpty((CharSequence)fileExtension)) {
            return null;
        }
        if (EXTENSION_CSV.equals(fileExtension = fileExtension.toLowerCase())) {
            return CSV;
        }
        if (EXTENSION_XLS.equals(fileExtension) || EXTENSION_XLSX.equals(fileExtension)) {
            return XLS;
        }
        return null;
    }

    public static String getExtension(String fileName) {
        if (StringUtils.isEmpty((CharSequence)fileName)) {
            return "";
        }
        int index = fileName.lastIndexOf(EXTENSION_SEPARATOR);
        if (index < 0) {
            return "";
        }
        return fileName.substring(index + 1);
    }
}

