/*
 * Decompiled with CFR 0.152.
 */
package io.github.changebooks.worksheet;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelReader;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.excel.exception.ExcelAnalysisStopException;
import com.alibaba.excel.read.listener.ReadListener;
import com.alibaba.excel.read.metadata.ReadSheet;
import com.alibaba.excel.read.metadata.holder.ReadRowHolder;
import com.alibaba.excel.read.metadata.holder.ReadSheetHolder;
import com.google.common.base.Preconditions;
import io.github.changebooks.worksheet.WorksheetType;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public final class ReadUtils {
    private ReadUtils() {
    }

    public static Integer getLineNum(File file) throws IOException {
        return ReadUtils.getLineNum(file, null);
    }

    public static Integer getLineNum(File file, ReadSheet sheet) throws IOException {
        Preconditions.checkNotNull((Object)file, (Object)"file can't be null");
        WorksheetType type = WorksheetType.fromFile(file);
        try (FileInputStream stream = new FileInputStream(file);){
            Integer n = ReadUtils.getLineNum(type, stream, sheet);
            return n;
        }
    }

    public static Integer getLineNum(WorksheetType type, InputStream stream, ReadSheet sheet) throws IOException {
        WorksheetType.checkSupport(type);
        Preconditions.checkNotNull((Object)stream, (Object)"stream can't be null");
        switch (type) {
            case CSV: {
                return ReadUtils.getCsvRowSize(stream);
            }
            case XLS: {
                return ReadUtils.getXlsApproximateRowSize(stream, sheet);
            }
        }
        throw new RuntimeException("unsupported's type: " + (Object)((Object)type));
    }

    /*
     * Exception decompiling
     */
    public static Integer getCsvRowSize(InputStream stream) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Integer getXlsApproximateRowSize(InputStream stream, ReadSheet sheet) {
        if (Objects.isNull(stream)) {
            return null;
        }
        final Integer[] result = new Integer[1];
        ExcelReader reader = EasyExcel.read((InputStream)stream, (ReadListener)new AnalysisEventListener<Map<Integer, String>>(){

            public void invoke(Map<Integer, String> data, AnalysisContext context) {
                result[0] = ReadUtils.getRowSize(context);
                throw new ExcelAnalysisStopException();
            }

            public void doAfterAllAnalysed(AnalysisContext context) {
            }
        }).build();
        if (Objects.isNull(reader)) {
            return null;
        }
        if (Objects.isNull(sheet)) {
            sheet = EasyExcel.readSheet((Integer)0).build();
        }
        try {
            reader.read(new ReadSheet[]{sheet});
            Integer n = result[0];
            return n;
        }
        finally {
            reader.finish();
        }
    }

    public static Integer getRowSize(AnalysisContext c) {
        if (Objects.isNull(c)) {
            return null;
        }
        ReadSheetHolder sheetHolder = c.readSheetHolder();
        if (Objects.isNull(sheetHolder)) {
            return null;
        }
        return sheetHolder.getApproximateTotalRowNumber();
    }

    public static Integer getRowIndex(AnalysisContext c) {
        if (Objects.isNull(c)) {
            return null;
        }
        ReadRowHolder rowHolder = c.readRowHolder();
        if (Objects.isNull(rowHolder)) {
            return null;
        }
        return rowHolder.getRowIndex();
    }

    public static Map<String, String> combine(Map<Integer, String> keys, Map<Integer, String> values) {
        if (Objects.isNull(values)) {
            return null;
        }
        Preconditions.checkNotNull(keys, (Object)"keys can't be null");
        int keySize = keys.size();
        Preconditions.checkArgument((keySize > 0 ? 1 : 0) != 0, (Object)"keys can't be empty");
        HashMap<String, String> result = new HashMap<String, String>(keySize);
        for (Integer columnIndex : keys.keySet()) {
            String key = keys.get(columnIndex);
            String value = values.get(columnIndex);
            result.put(key, value);
        }
        return result;
    }

    public static Map<Integer, String> asKey(Map<Integer, String> values) {
        Preconditions.checkNotNull(values, (Object)"values can't be null");
        int size = values.size();
        Preconditions.checkArgument((size > 0 ? 1 : 0) != 0, (Object)"values can't be empty");
        HashMap<Integer, String> result = new HashMap<Integer, String>(size);
        for (Map.Entry<Integer, String> entry : values.entrySet()) {
            String key;
            String value;
            Integer columnIndex = entry.getKey();
            if (Objects.isNull(columnIndex) || columnIndex < 0 || Objects.isNull(value = entry.getValue()) || (key = value.trim()).length() == 0) continue;
            Preconditions.checkArgument((!result.containsValue(key) ? 1 : 0) != 0, (Object)String.format("duplicated's key: %s, columnIndex: %d", key, columnIndex));
            result.put(columnIndex, key);
        }
        return result;
    }

    public static Map<Integer, String> asMap(String[] values) {
        if (Objects.isNull(values)) {
            return null;
        }
        int len = values.length;
        HashMap<Integer, String> result = new HashMap<Integer, String>(len);
        for (int i = 0; i < len; ++i) {
            result.put(i, values[i]);
        }
        return result;
    }
}

