/*
 * Decompiled with CFR 0.152.
 */
package io.github.changebooks.worksheet;

import com.alibaba.excel.read.metadata.ReadSheet;
import com.google.common.base.Preconditions;
import io.github.changebooks.worksheet.ReadLine;
import io.github.changebooks.worksheet.WorksheetType;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ReadSync {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReadSync.class);
    private final ReadSheet sheet;

    public static ReadSync create() {
        return ReadSync.create(null);
    }

    public static ReadSync create(ReadSheet sheet) {
        return new ReadSync(sheet);
    }

    private ReadSync(ReadSheet sheet) {
        this.sheet = sheet;
    }

    public List<Map<String, String>> read(File file) throws IOException {
        return ReadSync.read(file, this.sheet);
    }

    public List<Map<String, String>> read(WorksheetType type, InputStream stream) {
        return ReadSync.read(type, stream, this.sheet);
    }

    public ReadSheet getSheet() {
        return this.sheet;
    }

    public static List<Map<String, String>> read(File file, ReadSheet sheet) throws IOException {
        Preconditions.checkNotNull((Object)file, (Object)"file can't be null");
        WorksheetType type = WorksheetType.fromFile(file);
        try (FileInputStream stream = new FileInputStream(file);){
            List<Map<String, String>> list = ReadSync.read(type, stream, sheet);
            return list;
        }
    }

    public static List<Map<String, String>> read(WorksheetType type, InputStream stream, ReadSheet sheet) {
        final ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        ReadLine.read(type, stream, sheet, new ReadLine.Listener(){

            @Override
            public void invoke(Integer rowIndex, Map<String, String> valueMap) {
                if (Objects.isNull(valueMap)) {
                    LOGGER.error("read null, skip rowIndex: " + rowIndex);
                } else {
                    result.add(valueMap);
                }
            }

            @Override
            public void onComplete(Integer rowIndex) {
            }
        });
        return result;
    }
}

