/*
 * Decompiled with CFR 0.152.
 */
package io.github.changebooks.worksheet;

import com.alibaba.excel.read.metadata.ReadSheet;
import com.google.common.base.Preconditions;
import io.github.changebooks.worksheet.ReadLine;
import io.github.changebooks.worksheet.WorksheetType;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class ReadPage {
    private final int pageSize;
    private final ReadSheet sheet;

    public static ReadPage create(int pageSize) {
        return ReadPage.create(pageSize, null);
    }

    public static ReadPage create(int pageSize, ReadSheet sheet) {
        return new ReadPage(pageSize, sheet);
    }

    private ReadPage(int pageSize, ReadSheet sheet) {
        Preconditions.checkArgument((pageSize > 0 ? 1 : 0) != 0, (Object)"pageSize must be positive");
        this.pageSize = pageSize;
        this.sheet = sheet;
    }

    public void read(File file, Listener listener) throws IOException {
        this.read(file, this.sheet, listener);
    }

    public void read(WorksheetType type, InputStream stream, Listener listener) {
        this.read(type, stream, this.sheet, listener);
    }

    public void read(File file, ReadSheet sheet, Listener listener) throws IOException {
        Preconditions.checkNotNull((Object)file, (Object)"file can't be null");
        WorksheetType type = WorksheetType.fromFile(file);
        try (FileInputStream stream = new FileInputStream(file);){
            this.read(type, stream, sheet, listener);
        }
    }

    public void read(WorksheetType type, InputStream stream, ReadSheet sheet, final Listener listener) {
        Preconditions.checkNotNull((Object)listener, (Object)"listener can't be null");
        final Integer[] startRow = new Integer[]{null};
        final ArrayList<Map<String, String>> data = new ArrayList<Map<String, String>>();
        ReadLine.read(type, stream, sheet, new ReadLine.Listener(){

            @Override
            public void invoke(Integer rowIndex, Map<String, String> valueMap) {
                if (Objects.isNull(startRow[0])) {
                    startRow[0] = rowIndex;
                }
                if (data.size() < ReadPage.this.pageSize) {
                    data.add(valueMap);
                }
                if (data.size() >= ReadPage.this.pageSize) {
                    listener.invoke(startRow[0], data);
                    startRow[0] = null;
                    data.clear();
                }
            }

            @Override
            public void onComplete(Integer rowIndex) {
            }
        });
        if (data.size() > 0) {
            listener.invoke(startRow[0], data);
            data.clear();
        }
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public ReadSheet getSheet() {
        return this.sheet;
    }

    public static interface Listener {
        public void invoke(Integer var1, List<Map<String, String>> var2);
    }
}

