/*
 * Decompiled with CFR 0.152.
 */
package io.github.changebooks.worksheet;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelReader;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.excel.exception.ExcelAnalysisStopException;
import com.alibaba.excel.read.builder.ExcelReaderBuilder;
import com.alibaba.excel.read.listener.ReadListener;
import com.alibaba.excel.read.metadata.ReadSheet;
import com.alibaba.excel.support.ExcelTypeEnum;
import com.google.common.base.Preconditions;
import io.github.changebooks.worksheet.ReadUtils;
import io.github.changebooks.worksheet.StopException;
import io.github.changebooks.worksheet.WorksheetType;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Objects;

public final class ReadLine {
    private final ReadSheet sheet;

    public static ReadLine create() {
        return ReadLine.create(null);
    }

    public static ReadLine create(ReadSheet sheet) {
        return new ReadLine(sheet);
    }

    private ReadLine(ReadSheet sheet) {
        this.sheet = sheet;
    }

    public void read(File file, Listener listener) throws IOException {
        ReadLine.read(file, this.sheet, listener);
    }

    public void read(WorksheetType type, InputStream stream, Listener listener) {
        ReadLine.read(type, stream, this.sheet, listener);
    }

    public ReadSheet getSheet() {
        return this.sheet;
    }

    public static void read(File file, ReadSheet sheet, Listener listener) throws IOException {
        Preconditions.checkNotNull((Object)file, (Object)"file can't be null");
        WorksheetType type = WorksheetType.fromFile(file);
        try (FileInputStream stream = new FileInputStream(file);){
            ReadLine.read(type, stream, sheet, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void read(WorksheetType type, InputStream stream, ReadSheet sheet, final Listener listener) {
        ExcelReader reader;
        WorksheetType.checkSupport(type);
        Preconditions.checkNotNull((Object)stream, (Object)"stream can't be null");
        Preconditions.checkNotNull((Object)listener, (Object)"listener can't be null");
        ExcelReaderBuilder builder = EasyExcel.read((InputStream)stream, (ReadListener)new AnalysisEventListener<Map<Integer, String>>(){
            private Map<Integer, String> keys;

            public void invokeHeadMap(Map<Integer, String> headMap, AnalysisContext context) {
                super.invokeHeadMap(headMap, context);
                this.keys = ReadUtils.asKey(headMap);
            }

            public void invoke(Map<Integer, String> valueMap, AnalysisContext context) {
                Integer rowIndex = ReadUtils.getRowIndex(context);
                try {
                    Map<String, String> data = ReadUtils.combine(this.keys, valueMap);
                    listener.invoke(rowIndex, data);
                }
                catch (StopException e) {
                    throw new ExcelAnalysisStopException();
                }
            }

            public void doAfterAllAnalysed(AnalysisContext context) {
                Integer rowIndex = ReadUtils.getRowIndex(context);
                listener.onComplete(rowIndex);
            }
        });
        if (WorksheetType.isCsv(type)) {
            builder.excelType(ExcelTypeEnum.CSV);
        }
        if (Objects.isNull(reader = builder.build())) {
            return;
        }
        if (Objects.isNull(sheet)) {
            sheet = EasyExcel.readSheet((Integer)0).build();
        }
        try {
            reader.read(new ReadSheet[]{sheet});
        }
        finally {
            reader.finish();
        }
    }

    public static interface Listener {
        public void invoke(Integer var1, Map<String, String> var2);

        public void onComplete(Integer var1);
    }
}

