/*
 * Decompiled with CFR 0.152.
 */
package io.github.changebooks.kafka;

import java.util.AbstractList;
import java.util.List;
import org.springframework.util.Assert;

public final class PageUtils {
    public static <T> List<List<T>> compute(List<T> list, int size) {
        Assert.notNull(list, (String)"list can't be null");
        Assert.isTrue((size > 0 ? 1 : 0) != 0, (String)"size must be greater than 0");
        int pageSize = (int)Math.ceil((double)list.size() / (double)size);
        pageSize = Math.max(pageSize, 1);
        return new PageList<T>(list, pageSize);
    }

    public static <T> List<List<T>> page(List<T> list, int pageSize) {
        Assert.notNull(list, (String)"list can't be null");
        Assert.isTrue((pageSize > 0 ? 1 : 0) != 0, (String)"pageSize must be greater than 0");
        return new PageList<T>(list, pageSize);
    }

    private static class PageList<T>
    extends AbstractList<List<T>> {
        final List<T> list;
        final int pageSize;
        final int totalSize;
        final int size;

        PageList(List<T> list, int pageSize) {
            this.list = list;
            this.pageSize = pageSize;
            this.totalSize = list.size();
            this.size = (int)Math.ceil((double)this.totalSize / (double)pageSize);
        }

        @Override
        public List<T> get(int index) {
            this.rangeCheck(index);
            int start = index * this.pageSize;
            int end = Math.min(start + this.pageSize, this.totalSize);
            return this.list.subList(start, end);
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public boolean isEmpty() {
            return this.list.isEmpty();
        }

        private void rangeCheck(int index) {
            if (index < 0 || index >= this.size) {
                throw new IndexOutOfBoundsException("index range is [0, " + this.size + ")");
            }
        }
    }
}

