/*
 * Decompiled with CFR 0.152.
 */
package io.github.changebooks.kafka;

import io.github.changebooks.kafka.KafkaHeaders;
import io.github.changebooks.kafka.KafkaLogId;
import io.github.changebooks.kafka.KafkaTraceId;
import java.util.Map;
import org.apache.kafka.clients.producer.ProducerInterceptor;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeaders;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogProducerInterceptor<K, V>
implements ProducerInterceptor<K, V> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogProducerInterceptor.class);

    public ProducerRecord<K, V> onSend(ProducerRecord<K, V> rawRecord) {
        if (rawRecord == null) {
            return null;
        }
        ProducerRecord<K, V> record = null;
        try {
            record = this.processLog(rawRecord);
        }
        catch (Throwable tr) {
            LOGGER.error("onSend failed, throwable: ", tr);
        }
        if (record != null) {
            return record;
        }
        return rawRecord;
    }

    public ProducerRecord<K, V> processLog(ProducerRecord<K, V> record) {
        RecordHeaders headers = new RecordHeaders();
        KafkaTraceId.onSend((Headers)headers);
        KafkaLogId.onSend((Headers)headers);
        return KafkaHeaders.addProducer(record, (Headers)headers);
    }

    public void onAcknowledgement(RecordMetadata metadata, Exception exception) {
    }

    public void close() {
    }

    public void configure(Map<String, ?> configs) {
    }
}

