/*
 * Decompiled with CFR 0.152.
 */
package io.github.changebooks.kafka;

import io.github.changebooks.kafka.KafkaHeaders;
import io.github.changebooks.kafka.KafkaLogId;
import io.github.changebooks.kafka.KafkaTraceId;
import io.github.changebooks.log.LogClear;
import io.github.changebooks.log.LogId;
import io.github.changebooks.log.LogTraceId;
import java.util.Map;
import org.apache.kafka.clients.consumer.ConsumerInterceptor;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.header.Headers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogConsumerInterceptor<K, V>
implements ConsumerInterceptor<K, V> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogConsumerInterceptor.class);

    public ConsumerRecords<K, V> onConsume(ConsumerRecords<K, V> records) {
        if (records == null) {
            return null;
        }
        try {
            this.processLog(records);
        }
        catch (Throwable tr) {
            LOGGER.error("onConsume failed, throwable: ", tr);
        }
        return records;
    }

    public void processLog(ConsumerRecords<K, V> records) {
        Headers headers = KafkaHeaders.getConsumer(records);
        if (headers == null) {
            LogTraceId.init();
            LogId.init();
        } else {
            KafkaTraceId.onConsume(headers);
            KafkaLogId.onConsume(headers);
        }
    }

    public void onCommit(Map<TopicPartition, OffsetAndMetadata> offsets) {
        LogClear.clear();
    }

    public void close() {
    }

    public void configure(Map<String, ?> configs) {
    }
}

