/*
 * Decompiled with CFR 0.152.
 */
package io.github.changebooks.kafka;

import io.github.changebooks.kafka.KafkaHeaders;
import io.github.changebooks.log.LogTraceId;
import java.util.Objects;
import org.apache.kafka.common.header.Headers;
import org.springframework.util.StringUtils;

public final class KafkaTraceId {
    public static final String KEY_NAME = "log_tid";

    private KafkaTraceId() {
    }

    public static void onConsume(Headers headers) {
        Objects.requireNonNull(headers, "headers can't be null");
        String traceId = KafkaHeaders.get(headers, KEY_NAME);
        if (StringUtils.hasText((String)traceId)) {
            LogTraceId.set((String)traceId);
        } else {
            LogTraceId.init();
        }
    }

    public static void onSend(Headers headers) {
        Objects.requireNonNull(headers, "headers can't be null");
        String traceId = LogTraceId.get();
        if (StringUtils.hasText((String)traceId)) {
            KafkaHeaders.set(headers, KEY_NAME, traceId);
            return;
        }
        traceId = KafkaHeaders.get(headers, KEY_NAME);
        if (StringUtils.hasText((String)traceId)) {
            return;
        }
        LogTraceId.init();
        traceId = LogTraceId.get();
        KafkaHeaders.set(headers, KEY_NAME, traceId);
    }
}

