/*
 * Decompiled with CFR 0.152.
 */
package io.github.changebooks.kafka;

import io.github.changebooks.kafka.KafkaHeaders;
import io.github.changebooks.log.LogId;
import io.github.changebooks.log.LogParentId;
import java.util.Objects;
import org.apache.kafka.common.header.Headers;
import org.springframework.util.StringUtils;

public final class KafkaLogId {
    public static final String KEY_NAME = "log_id";

    private KafkaLogId() {
    }

    public static void onConsume(Headers headers) {
        Objects.requireNonNull(headers, "headers can't be null");
        String logId = KafkaHeaders.get(headers, KEY_NAME);
        if (StringUtils.hasText((String)logId)) {
            LogParentId.set((String)logId);
        }
        LogId.init();
    }

    public static void onSend(Headers headers) {
        Objects.requireNonNull(headers, "headers can't be null");
        String logId = LogId.get();
        if (StringUtils.hasText((String)logId)) {
            KafkaHeaders.set(headers, KEY_NAME, logId);
            return;
        }
        logId = KafkaHeaders.get(headers, KEY_NAME);
        if (StringUtils.hasText((String)logId)) {
            return;
        }
        LogId.init();
        logId = LogId.get();
        KafkaHeaders.set(headers, KEY_NAME, logId);
    }
}

