/*
 * Decompiled with CFR 0.152.
 */
package io.github.changebooks.kafka;

import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.utils.Utils;

public final class KafkaHeaders {
    private KafkaHeaders() {
    }

    public static <K, V> Headers getConsumer(ConsumerRecords<K, V> records) {
        if (records == null) {
            return null;
        }
        for (ConsumerRecord r : records) {
            Headers headers;
            if (r == null || (headers = r.headers()) == null) continue;
            return headers;
        }
        return null;
    }

    public static <K, V> ProducerRecord<K, V> addProducer(ProducerRecord<K, V> record, Headers headers) {
        if (record == null) {
            return null;
        }
        if (headers == null) {
            return record;
        }
        headers = KafkaHeaders.addAll(record.headers(), headers);
        return new ProducerRecord(record.topic(), record.partition(), record.timestamp(), record.key(), record.value(), (Iterable)headers);
    }

    public static String get(Headers headers, String key) {
        if (headers == null) {
            return null;
        }
        Header h = headers.lastHeader(key);
        if (h == null) {
            return null;
        }
        byte[] value = h.value();
        if (value == null) {
            return null;
        }
        return Utils.utf8((byte[])value);
    }

    public static Headers set(Headers headers, String key, String value) {
        if (headers == null) {
            return null;
        }
        if (value == null) {
            return headers;
        }
        return headers.add(key, Utils.utf8((String)value));
    }

    public static Headers addAll(Headers headers, Headers others) {
        if (headers == null) {
            return others;
        }
        if (others == null) {
            return headers;
        }
        for (Header o : others) {
            if (o == null) continue;
            headers.add(o);
        }
        return headers;
    }
}

