/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdiunit.testng.internal;

import io.github.cdiunit.internal.ExceptionUtils;
import io.github.cdiunit.internal.TestLifecycle;
import io.github.cdiunit.internal.TestMethodInvocationContext;
import java.lang.reflect.Method;
import org.testng.IHookCallBack;
import org.testng.ITestResult;

public class InvokeInterceptors
implements IHookCallBack {
    private final IHookCallBack next;
    private final TestLifecycle testLifecycle;
    private TestMethodInvocationContext<?> methodInvocationContext;

    public InvokeInterceptors(IHookCallBack next, TestLifecycle testLifecycle) {
        this.next = next;
        this.testLifecycle = testLifecycle;
    }

    public void runTestMethod(ITestResult testResult) {
        if (this.methodInvocationContext == null) {
            Object target = testResult.getInstance();
            Object[] parameters = this.next.getParameters();
            Method method = this.testLifecycle.getTestMethod();
            this.methodInvocationContext = new TestMethodInvocationContext(target, method, parameters, () -> this.next.runTestMethod(testResult));
            this.methodInvocationContext.resolveInterceptors(this.testLifecycle.getBeanManager());
        }
        try {
            this.methodInvocationContext.proceed();
        }
        catch (Exception e) {
            throw ExceptionUtils.asRuntimeException((Throwable)e);
        }
    }

    public Object[] getParameters() {
        return this.next.getParameters();
    }
}

