/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdiunit.testng;

import io.github.cdiunit.internal.ExceptionUtils;
import io.github.cdiunit.internal.TestConfiguration;
import io.github.cdiunit.internal.TestLifecycle;
import io.github.cdiunit.internal.activatescopes.ScopesHelper;
import io.github.cdiunit.testng.internal.InvokeInterceptors;
import jakarta.enterprise.inject.spi.BeanManager;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Spliterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.stream.StreamSupport;
import org.testng.IClassListener;
import org.testng.IHookCallBack;
import org.testng.IHookable;
import org.testng.IInvokedMethod;
import org.testng.IInvokedMethodListener;
import org.testng.ITestClass;
import org.testng.ITestResult;
import org.testng.annotations.Listeners;

public class NgCdiListener
implements IHookable,
IClassListener,
IInvokedMethodListener {
    private final Map<Class<?>, NgTestLifecycle> testLifecycles = new ConcurrentHashMap();

    private NgTestLifecycle initialTestLifecycle(ITestClass ngTestClass) {
        final Class testClass = ngTestClass.getRealClass();
        Spliterator superClassSpliterator = new Spliterator<Class<?>>(){
            Class<?> aClass;
            {
                this.aClass = testClass;
            }

            @Override
            public boolean tryAdvance(Consumer<? super Class<?>> action) {
                if (this.aClass == null) {
                    return false;
                }
                action.accept(this.aClass);
                this.aClass = this.aClass.getSuperclass();
                return true;
            }

            @Override
            public Spliterator<Class<?>> trySplit() {
                return null;
            }

            @Override
            public long estimateSize() {
                return 0L;
            }

            @Override
            public int characteristics() {
                return 1297;
            }
        };
        boolean configuredOnClass = StreamSupport.stream(superClassSpliterator, false).map(c -> c.getAnnotation(Listeners.class)).filter(Objects::nonNull).flatMap(a -> Arrays.stream(a.value())).anyMatch(NgCdiListener.class::isAssignableFrom);
        return this.testLifecycles.computeIfAbsent(testClass, aClass -> new NgTestLifecycle(new TestConfiguration(aClass, null), configuredOnClass));
    }

    private NgTestLifecycle requiredTestLifecycle(ITestClass ngTestClass, Method method) {
        NgTestLifecycle testLifecycle = this.initialTestLifecycle(ngTestClass);
        if (method != null) {
            testLifecycle.setTestMethod(method);
        }
        return testLifecycle;
    }

    public void onBeforeClass(ITestClass testClass) {
        NgTestLifecycle testLifecycle = this.initialTestLifecycle(testClass);
        if (!testLifecycle.configuredOnClass) {
            return;
        }
        testLifecycle.beforeTestClass();
    }

    public void onAfterClass(ITestClass testClass) {
        NgTestLifecycle testLifecycle = this.requiredTestLifecycle(testClass, null);
        if (!testLifecycle.configuredOnClass) {
            return;
        }
        try {
            testLifecycle.afterTestClass();
        }
        catch (Exception e) {
            throw ExceptionUtils.asRuntimeException((Throwable)e);
        }
        finally {
            this.testLifecycles.remove(testClass.getRealClass());
        }
    }

    public void beforeInvocation(IInvokedMethod invokedMethod, ITestResult testResult) {
        Method method = invokedMethod.getTestMethod().getConstructorOrMethod().getMethod();
        NgTestLifecycle testLifecycle = this.requiredTestLifecycle(testResult.getMethod().getTestClass(), method);
        if (!testLifecycle.configuredOnClass) {
            return;
        }
        Object target = testResult.getInstance();
        try {
            testLifecycle.configureTest(target);
            testLifecycle.beforeTestMethod();
        }
        catch (Throwable t) {
            testResult.setThrowable(t);
            testResult.setStatus(2);
        }
    }

    public void afterInvocation(IInvokedMethod invokedMethod, ITestResult testResult) {
        Method method = invokedMethod.getTestMethod().getConstructorOrMethod().getMethod();
        NgTestLifecycle testLifecycle = this.requiredTestLifecycle(testResult.getMethod().getTestClass(), method);
        if (!testLifecycle.configuredOnClass) {
            return;
        }
        try {
            testLifecycle.afterTestMethod();
        }
        catch (Throwable t) {
            testResult.setThrowable(t);
            testResult.setStatus(2);
        }
    }

    public void run(IHookCallBack callBack, ITestResult testResult) {
        Method method = testResult.getMethod().getConstructorOrMethod().getMethod();
        NgTestLifecycle testLifecycle = this.requiredTestLifecycle(testResult.getMethod().getTestClass(), method);
        if (method == null || !testLifecycle.configuredOnClass) {
            callBack.runTestMethod(testResult);
            return;
        }
        try {
            new InvokeInterceptors(callBack, testLifecycle).runTestMethod(testResult);
        }
        catch (Throwable t) {
            testResult.setThrowable(t);
            testResult.setStatus(2);
        }
    }

    static class NgTestLifecycle
    extends TestLifecycle {
        private final boolean configuredOnClass;

        public NgTestLifecycle(TestConfiguration testConfiguration, boolean configuredOnClass) {
            super(testConfiguration);
            this.configuredOnClass = configuredOnClass;
        }

        protected void afterConfigure(Class<?> testClass, Object testInstance) throws Throwable {
            super.afterConfigure(testClass, testInstance);
            this.addBeforeMethod(testLifecycle -> ScopesHelper.activateContexts((BeanManager)testLifecycle.getBeanManager(), (Object)testLifecycle.getTestMethod()));
            this.addAfterMethod(testLifecycle -> ScopesHelper.deactivateContexts((BeanManager)testLifecycle.getBeanManager(), (Object)testLifecycle.getTestMethod()));
        }
    }
}

