/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdiunit.spock.internal;

import io.github.cdiunit.internal.TestConfiguration;
import io.github.cdiunit.internal.TestLifecycle;
import io.github.cdiunit.spock.CdiUnit;
import io.github.cdiunit.spock.internal.ActivateScopes;
import io.github.cdiunit.spock.internal.InvokeBoundInterceptors;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.spockframework.runtime.extension.IAnnotationDrivenExtension;
import org.spockframework.runtime.extension.IMethodInterceptor;
import org.spockframework.runtime.extension.IMethodInvocation;
import org.spockframework.runtime.extension.IStore;
import org.spockframework.runtime.model.FeatureInfo;
import org.spockframework.runtime.model.SpecInfo;

public class CdiSpockExtension
implements IAnnotationDrivenExtension<CdiUnit> {
    private static final IStore.Namespace NAMESPACE = IStore.Namespace.create((Object[])new Object[]{CdiSpockExtension.class});
    private final Map<Class<?>, TestLifecycle> testLifecycles = new ConcurrentHashMap();

    private TestLifecycle initialTestLifecycle(Class<?> testClass) {
        return this.testLifecycles.computeIfAbsent(testClass, aClass -> new TestLifecycle(new TestConfiguration(aClass, null)));
    }

    private TestLifecycle requiredTestLifecycle(Class<?> testClass, Method method) {
        TestLifecycle testLifecycle = this.initialTestLifecycle(testClass);
        if (method != null) {
            testLifecycle.setTestMethod(method);
        }
        return testLifecycle;
    }

    public void visitSpecAnnotations(List<CdiUnit> annotations, SpecInfo spec) {
        spec.addSetupSpecInterceptor((IMethodInterceptor)new SetupInterceptor());
        spec.addCleanupSpecInterceptor((IMethodInterceptor)new CleanupInterceptor());
    }

    public void visitSpec(SpecInfo spec) {
        List<ActivateScopes> featureInterceptors = List.of(new InjectTestInstance(), new AroundMethod(), new InvokeBoundInterceptors(NAMESPACE), new ActivateScopes(NAMESPACE));
        spec.getAllFeatures().forEach(feature -> featureInterceptors.forEach(arg_0 -> ((FeatureInfo)feature).addIterationInterceptor(arg_0)));
    }

    private class SetupInterceptor
    implements IMethodInterceptor {
        private SetupInterceptor() {
        }

        public void intercept(IMethodInvocation invocation) throws Throwable {
            Object instance = invocation.getInstance();
            TestLifecycle testLifecycle = CdiSpockExtension.this.initialTestLifecycle(instance.getClass());
            testLifecycle.beforeTestClass();
            invocation.proceed();
        }
    }

    private class CleanupInterceptor
    implements IMethodInterceptor {
        private CleanupInterceptor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void intercept(IMethodInvocation invocation) throws Throwable {
            try {
                invocation.proceed();
            }
            finally {
                Object instance = invocation.getInstance();
                Class<?> testClass = instance.getClass();
                TestLifecycle testLifecycle = CdiSpockExtension.this.initialTestLifecycle(testClass);
                try {
                    testLifecycle.afterTestClass();
                }
                finally {
                    CdiSpockExtension.this.testLifecycles.remove(testClass);
                }
            }
        }
    }

    private class InjectTestInstance
    implements IMethodInterceptor {
        private InjectTestInstance() {
        }

        public void intercept(IMethodInvocation invocation) throws Throwable {
            Object instance = invocation.getInstance();
            Method method = (Method)invocation.getFeature().getFeatureMethod().getReflection();
            TestLifecycle testLifecycle = CdiSpockExtension.this.requiredTestLifecycle(instance.getClass(), method);
            testLifecycle.configureTest(instance);
            invocation.proceed();
        }
    }

    private class AroundMethod
    implements IMethodInterceptor {
        private AroundMethod() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void intercept(IMethodInvocation invocation) throws Throwable {
            Object instance = invocation.getInstance();
            Method method = (Method)invocation.getFeature().getFeatureMethod().getReflection();
            TestLifecycle testLifecycle = CdiSpockExtension.this.requiredTestLifecycle(instance.getClass(), method);
            try {
                testLifecycle.beforeTestMethod();
                invocation.getStore(NAMESPACE).put((Object)invocation, (Object)testLifecycle);
                invocation.proceed();
            }
            finally {
                testLifecycle.afterTestMethod();
            }
        }
    }
}

