/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdiunit.junit4.internal;

import io.github.cdiunit.internal.ClassLookup;
import io.github.cdiunit.internal.DiscoveryExtension;
import io.github.cdiunit.junit4.internal.InvalidRuleFieldUsageException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

public class InvalidRuleFieldUsageDiscoveryExtension
implements DiscoveryExtension {
    public static final String INVALID_RULE_USAGE_MESSAGE = "Invalid @Rule usage detected on field %s of class %s. To use rules in CDI tests, put the @Rule annotation on a method instead of a field.";
    private final Class<? extends Annotation> fieldAnnotation = ClassLookup.INSTANCE.lookup("org.junit.Rule");

    @Override
    public void bootstrap(DiscoveryExtension.BootstrapDiscoveryContext bdc) {
        if (this.fieldAnnotation == null) {
            return;
        }
        bdc.discoverField(this::discoverField);
    }

    private void discoverField(DiscoveryExtension.Context context, Field field) {
        boolean acceptedRuleFieldModifiers;
        if (field.getAnnotation(this.fieldAnnotation) == null) {
            return;
        }
        Class<?> testClass = context.getTestConfiguration().getTestClass();
        Class<?> declaringClass = field.getDeclaringClass();
        int fieldModifiers = field.getModifiers();
        boolean bl = acceptedRuleFieldModifiers = Modifier.isPublic(fieldModifiers) && !Modifier.isStatic(fieldModifiers);
        if (declaringClass.isAssignableFrom(testClass) && acceptedRuleFieldModifiers) {
            String message = String.format(INVALID_RULE_USAGE_MESSAGE, field.getName(), declaringClass.getName());
            throw new InvalidRuleFieldUsageException(message);
        }
    }
}

