/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdiunit.junit4;

import io.github.cdiunit.internal.ExceptionUtils;
import io.github.cdiunit.internal.TestConfiguration;
import io.github.cdiunit.internal.TestLifecycle;
import io.github.cdiunit.junit4.internal.ActivateScopes;
import io.github.cdiunit.junit4.internal.AroundMethod;
import io.github.cdiunit.junit4.internal.ExpectStartupException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;

public class CdiRunner
extends BlockJUnit4ClassRunner {
    private final TestLifecycle testLifecycle;
    private final AtomicBoolean contextsActivated = new AtomicBoolean();

    public CdiRunner(Class<?> clazz) throws InitializationError {
        super(clazz);
        TestConfiguration testConfiguration = new TestConfiguration(clazz, null);
        this.testLifecycle = new TestLifecycle(testConfiguration);
    }

    protected Object createTest() {
        try {
            return this.testLifecycle.createTest(null);
        }
        catch (Throwable t) {
            throw ExceptionUtils.asRuntimeException(t);
        }
    }

    protected Statement classBlock(RunNotifier notifier) {
        final Statement defaultStatement = super.classBlock(notifier);
        return new Statement(){

            public void evaluate() throws Throwable {
                try {
                    CdiRunner.this.testLifecycle.beforeTestClass();
                    defaultStatement.evaluate();
                }
                finally {
                    CdiRunner.this.testLifecycle.afterTestClass();
                }
            }
        };
    }

    protected Statement methodBlock(FrameworkMethod frameworkMethod) {
        this.testLifecycle.setTestMethod(frameworkMethod.getMethod());
        Statement statement = super.methodBlock(frameworkMethod);
        statement = new ActivateScopes(statement, this.testLifecycle, this.contextsActivated);
        statement = new ExpectStartupException(statement, this.testLifecycle);
        return new AroundMethod(statement, this.testLifecycle);
    }
}

