/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdiunit.internal.servlet;

import io.github.cdiunit.internal.servlet.CdiUnitInitialListener;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.http.HttpSessionEvent;

public class LifecycleAwareRequest
extends HttpServletRequestWrapper {
    private final CdiUnitInitialListener listener;

    public LifecycleAwareRequest(CdiUnitInitialListener listener, HttpServletRequest request) {
        super(request);
        this.listener = listener;
    }

    private HttpSession getSessionAndNotify(boolean create) {
        HttpSession previousSession = super.getSession(false);
        HttpSession session = super.getSession(create);
        if (previousSession == null && session != null) {
            this.listener.sessionCreated(new HttpSessionEvent(session));
        }
        return session;
    }

    public HttpSession getSession() {
        return this.getSessionAndNotify(true);
    }

    public HttpSession getSession(boolean create) {
        return this.getSessionAndNotify(create);
    }
}

