/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdiunit.internal.jaxrs;

import io.github.cdiunit.ContextController;
import io.github.cdiunit.internal.jaxrs.JaxRsQualifier;
import io.github.cdiunit.internal.jaxrs.RequestImpl;
import io.github.cdiunit.internal.servlet.common.CdiUnitServlet;
import jakarta.enterprise.context.RequestScoped;
import jakarta.enterprise.context.SessionScoped;
import jakarta.enterprise.inject.Produces;
import jakarta.inject.Inject;
import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Request;
import jakarta.ws.rs.core.SecurityContext;
import jakarta.ws.rs.core.UriInfo;
import jakarta.ws.rs.ext.Providers;
import org.jboss.resteasy.plugins.server.servlet.ServletUtil;
import org.mockito.Mockito;

public class JaxRsProducers {
    @Inject
    @CdiUnitServlet
    ServletContext servletContext;
    @Inject
    ContextController contextController;
    @Inject
    @CdiUnitServlet
    HttpServletResponse servletResponse;

    @Produces
    @JaxRsQualifier
    public ServletContext getServletContext() {
        return this.servletContext;
    }

    @Produces
    @RequestScoped
    @JaxRsQualifier
    public HttpServletRequest getHttpServletRequest() {
        return this.contextController.currentRequest();
    }

    @Produces
    @RequestScoped
    @JaxRsQualifier
    public HttpServletResponse getHttpServletResponse() {
        return this.servletResponse;
    }

    @Produces
    @SessionScoped
    @JaxRsQualifier
    public HttpSession getHttpSession() {
        return this.contextController.currentRequest().getSession();
    }

    @Produces
    @JaxRsQualifier
    public SecurityContext getSecurityContext() {
        return (SecurityContext)Mockito.mock(SecurityContext.class);
    }

    @Produces
    @RequestScoped
    @JaxRsQualifier
    public Request getRequest() {
        return new RequestImpl(this.getHttpServletRequest(), this.getHttpServletResponse());
    }

    @Produces
    @RequestScoped
    @JaxRsQualifier
    public UriInfo getUriInfo() {
        return ServletUtil.extractUriInfo((HttpServletRequest)this.getHttpServletRequest(), (String)"");
    }

    @Produces
    @RequestScoped
    @JaxRsQualifier
    public HttpHeaders getHttpHeaders() {
        return ServletUtil.extractHttpHeaders((HttpServletRequest)this.getHttpServletRequest());
    }

    @Produces
    @RequestScoped
    @JaxRsQualifier
    public Providers getProviders() {
        return (Providers)Mockito.mock(Providers.class);
    }
}

