/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdiunit.internal.events;

import io.github.cdiunit.internal.events.EventsForwardingExtension;
import io.github.cdiunit.internal.events.ForwardedEvents;
import jakarta.annotation.Priority;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.inject.Inject;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.Interceptor;
import jakarta.interceptor.InvocationContext;
import java.io.Serializable;

@Priority(value=3000)
@Interceptor
@ForwardedEvents
class ForwardingInterceptor
implements Serializable {
    @Inject
    private EventsForwardingExtension extension;
    @Inject
    BeanManager beanManager;

    ForwardingInterceptor() {
    }

    @AroundInvoke
    public Object forward(InvocationContext ic) throws Exception {
        EventsForwardingExtension.ObserverBinding binding = null;
        Object[] params = ic.getParameters();
        if (params.length > 0) {
            Class<?> eventType = params[0].getClass();
            binding = this.extension.getBinding(eventType);
        }
        if (binding == null) {
            return ic.proceed();
        }
        binding.invoke(this.beanManager, ic, params);
        return null;
    }
}

