/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdiunit.internal.events;

import io.github.cdiunit.internal.ExceptionUtils;
import io.github.cdiunit.internal.events.ForwardedEvents;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.Vetoed;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.BeforeShutdown;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.ProcessAnnotatedType;
import jakarta.interceptor.Interceptor;
import jakarta.interceptor.InvocationContext;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Spliterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

@Vetoed
public class EventsForwardingExtension
implements Extension {
    private static final Map<Class<?>, Map<Class<?>, List<Method>>> discoveredObserverMethods = new ConcurrentHashMap();
    private final Map<Class<?>, ObserverBinding> bindings = new ConcurrentHashMap();

    public void bind(Class<?> testClass, Object testInstance) {
        discoveredObserverMethods.computeIfAbsent(testClass, EventsForwardingExtension::findObserverMethods).forEach((eventType, actions) -> {
            ObserverBinding binding = new ObserverBinding((Class<?>)eventType, testInstance, (List<Method>)actions);
            this.bindings.put((Class<?>)eventType, binding);
        });
    }

    public void unbind() {
        this.bindings.clear();
    }

    ObserverBinding getBinding(Class<?> c) {
        return this.bindings.get(c);
    }

    void onShutdown(@Observes BeforeShutdown bs) {
        this.unbind();
    }

    private <T> void processAnnotatedType(@Observes ProcessAnnotatedType<T> pat) {
        AnnotatedType annotatedType = pat.getAnnotatedType();
        if (annotatedType.isAnnotationPresent(Interceptor.class)) {
            return;
        }
        Class javaClass = annotatedType.getJavaClass();
        if (Extension.class.isAssignableFrom(javaClass)) {
            return;
        }
        Map observerMethods = discoveredObserverMethods.computeIfAbsent(javaClass, EventsForwardingExtension::findObserverMethods);
        if (observerMethods.isEmpty()) {
            return;
        }
        pat.configureAnnotatedType().add((Annotation)ForwardedEvents.Literal.INSTANCE);
    }

    private static Map<Class<?>, List<Method>> findObserverMethods(final Class<?> targetClass) {
        Spliterator superClassSpliterator = new Spliterator<Class<?>>(){
            Class<?> aClass;
            {
                this.aClass = targetClass;
            }

            @Override
            public boolean tryAdvance(Consumer<? super Class<?>> action) {
                if (this.aClass == null) {
                    return false;
                }
                action.accept(this.aClass);
                this.aClass = this.aClass.getSuperclass();
                return true;
            }

            @Override
            public Spliterator<Class<?>> trySplit() {
                return null;
            }

            @Override
            public long estimateSize() {
                return 0L;
            }

            @Override
            public int characteristics() {
                return 1297;
            }
        };
        List superclasses = StreamSupport.stream(superClassSpliterator, false).collect(Collectors.toList());
        Collections.reverse(superclasses);
        return superclasses.stream().flatMap(c -> Arrays.stream(c.getDeclaredMethods())).filter(m -> {
            Annotation[][] a = m.getParameterAnnotations();
            if (a.length < 1) {
                return false;
            }
            return Arrays.stream(a[0]).map(Object::getClass).anyMatch(Observes.class::isAssignableFrom);
        }).filter(m -> Void.TYPE.equals(m.getReturnType())).collect(Collectors.groupingBy(mk -> mk.getParameterTypes()[0], Collectors.mapping(mv -> mv, Collectors.toList())));
    }

    static class ObserverBinding {
        final Class<?> eventType;
        final Object testInstance;
        final List<Method> observerMethods;

        ObserverBinding(Class<?> eventType, Object testInstance, List<Method> observerMethods) {
            this.eventType = eventType;
            this.testInstance = testInstance;
            this.observerMethods = observerMethods;
        }

        void invoke(BeanManager beanManager, InvocationContext ic, Object ... args) {
            for (Method m : this.observerMethods) {
                if (!this.matchingObserver(m, ic.getMethod(), args)) continue;
                try {
                    m.setAccessible(true);
                    m.invoke(this.testInstance, this.observerArgs(beanManager, m, args));
                }
                catch (IllegalAccessException e) {
                    throw ExceptionUtils.asRuntimeException(e);
                }
                catch (InvocationTargetException e) {
                    throw ExceptionUtils.asRuntimeException(e.getCause());
                }
            }
        }

        private boolean matchingObserver(Method candidate, Method intercepted, Object[] args) {
            Annotation[][] candidateAnnotations = candidate.getParameterAnnotations();
            if (candidateAnnotations.length < 1) {
                return false;
            }
            Annotation[][] interceptedAnnotations = intercepted.getParameterAnnotations();
            if (interceptedAnnotations.length < 1) {
                return false;
            }
            Set<Annotation> ca = Set.copyOf(Arrays.asList(candidateAnnotations[0]));
            Set<Annotation> ia = Set.copyOf(Arrays.asList(interceptedAnnotations[0]));
            HashSet<Annotation> remainingCandidate = new HashSet<Annotation>(ca);
            remainingCandidate.removeAll(ia);
            HashSet<Annotation> remainingIntercepted = new HashSet<Annotation>(ia);
            remainingIntercepted.removeAll(ca);
            return remainingCandidate.isEmpty() && remainingIntercepted.isEmpty();
        }

        private Object[] observerArgs(BeanManager beanManager, Method m, Object[] args) {
            ArrayList<Object> result = new ArrayList<Object>();
            if (args.length > 0) {
                result.add(args[0]);
            }
            Instance instance = beanManager.createInstance();
            Arrays.stream(m.getParameters()).skip(1L).forEach(p -> {
                Annotation[] qualifiers = (Annotation[])Arrays.stream(p.getAnnotations()).filter(a -> beanManager.isQualifier(a.getClass())).toArray(Annotation[]::new);
                Object v = instance.select(p.getType(), qualifiers).get();
                result.add(v);
            });
            return result.toArray();
        }
    }
}

