/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdiunit.internal.ejb;

import io.github.cdiunit.internal.ejb.DefaultLiteral;
import io.github.cdiunit.internal.ejb.EJbName;
import io.github.cdiunit.internal.ejb.EJbQualifier;
import jakarta.ejb.EJB;
import jakarta.ejb.Singleton;
import jakarta.ejb.Stateful;
import jakarta.ejb.Stateless;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.Produces;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.ProcessAnnotatedType;
import jakarta.enterprise.inject.spi.configurator.AnnotatedFieldConfigurator;
import jakarta.enterprise.inject.spi.configurator.AnnotatedMethodConfigurator;
import jakarta.enterprise.inject.spi.configurator.AnnotatedTypeConfigurator;
import jakarta.enterprise.util.AnnotationLiteral;
import jakarta.inject.Inject;
import java.lang.annotation.Annotation;
import java.util.stream.Collectors;

public class EjbExtension
implements Extension {
    public <T> void processAnnotatedType(@Observes ProcessAnnotatedType<T> pat) {
        EJB ejb;
        Stateful stateful;
        AnnotatedType annotatedType = pat.getAnnotatedType();
        AnnotatedTypeConfigurator builder = pat.configureAnnotatedType();
        Stateless stateless = (Stateless)annotatedType.getAnnotation(Stateless.class);
        if (stateless != null) {
            EjbExtension.processClass(builder, stateless.name());
        }
        if ((stateful = (Stateful)annotatedType.getAnnotation(Stateful.class)) != null) {
            EjbExtension.processClass(builder, stateful.name());
        }
        try {
            Singleton singleton = (Singleton)annotatedType.getAnnotation(Singleton.class);
            if (singleton != null) {
                EjbExtension.processClass(builder, singleton.name());
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        for (AnnotatedMethodConfigurator method : builder.filterMethods(m -> m.isAnnotationPresent(EJB.class)).collect(Collectors.toList())) {
            ejb = (EJB)method.getAnnotated().getAnnotation(EJB.class);
            method.add((Annotation)EJbQualifier.EJbQualifierLiteral.INSTANCE);
            method.remove(a -> a.annotationType().equals(EJB.class));
            if (!ejb.beanName().isEmpty()) {
                method.add((Annotation)new EJbName.EJbNameLiteral(ejb.beanName()));
                continue;
            }
            method.add((Annotation)DefaultLiteral.INSTANCE);
        }
        for (AnnotatedFieldConfigurator field : builder.filterFields(f -> f.isAnnotationPresent(EJB.class)).collect(Collectors.toList())) {
            ejb = (EJB)field.getAnnotated().getAnnotation(EJB.class);
            boolean producesPresent = field.getAnnotated().isAnnotationPresent(Produces.class);
            if (!producesPresent) {
                field.add((Annotation)new AnnotationLiteral<Inject>(){
                    private static final long serialVersionUID = 1L;
                });
            }
            field.remove(a -> a.annotationType().equals(EJB.class));
            field.add((Annotation)EJbQualifier.EJbQualifierLiteral.INSTANCE);
            if (!ejb.beanName().isEmpty()) {
                field.add((Annotation)new EJbName.EJbNameLiteral(ejb.beanName()));
                continue;
            }
            field.add((Annotation)DefaultLiteral.INSTANCE);
        }
    }

    private static <T> void processClass(AnnotatedTypeConfigurator<T> builder, String name) {
        builder.add((Annotation)new AnnotationLiteral<ApplicationScoped>(){
            private static final long serialVersionUID = 1L;
        });
        builder.add((Annotation)EJbQualifier.EJbQualifierLiteral.INSTANCE);
        if (!name.isEmpty()) {
            builder.add((Annotation)new EJbName.EJbNameLiteral(name));
        } else {
            builder.add((Annotation)DefaultLiteral.INSTANCE);
        }
    }
}

