/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdiunit.internal.activatescopes;

import io.github.cdiunit.ActivateScopes;
import io.github.cdiunit.internal.activatescopes.CdiContext;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.Vetoed;
import jakarta.enterprise.inject.spi.AfterBeanDiscovery;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.util.AnnotationLiteral;
import jakarta.inject.Qualifier;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

@Vetoed
public class ScopesExtension
implements Extension {
    private final Set<Class<? extends Annotation>> scopes;
    private List<CdiContext> contexts = List.of();

    public ScopesExtension(Set<Class<? extends Annotation>> scopes) {
        this.scopes = scopes;
    }

    void onAfterBeanDiscovery(@Observes AfterBeanDiscovery event, BeanManager beanManager) {
        if (this.scopes == null) {
            return;
        }
        this.contexts = this.scopes.stream().map(scope -> new CdiContext((Class<? extends Annotation>)scope, beanManager)).collect(Collectors.toList());
        this.contexts.forEach(arg_0 -> ((AfterBeanDiscovery)event).addContext(arg_0));
    }

    void onActivateContexts(@Observes @ActivateContexts Object event) {
        Collection<Class<? extends Annotation>> targetScopes = this.collectScopes(event);
        this.contexts.stream().filter(o -> targetScopes.contains(o.getScope())).forEach(CdiContext::activate);
    }

    void onDeactivateContexts(@Observes @DeactivateContexts Object event) {
        Collection<Class<? extends Annotation>> targetScopes = this.collectScopes(event);
        this.contexts.stream().filter(o -> targetScopes.contains(o.getScope())).forEach(CdiContext::deactivate);
    }

    private Collection<Class<? extends Annotation>> collectScopes(Object target) {
        LinkedHashSet<Class<? extends Annotation>> targetScopes = new LinkedHashSet<Class<? extends Annotation>>();
        if (target instanceof Method) {
            Method method = (Method)target;
            this.collectScopes(method, targetScopes);
            this.collectScopes(method.getDeclaringClass(), targetScopes);
        } else {
            this.collectScopes(target.getClass(), targetScopes);
        }
        return targetScopes;
    }

    private void collectScopes(AnnotatedElement target, Set<Class<? extends Annotation>> scopes) {
        if (target == null) {
            return;
        }
        Arrays.stream((ActivateScopes[])target.getAnnotationsByType(ActivateScopes.class)).flatMap(o -> Arrays.stream(o.value())).forEachOrdered(scopes::add);
        Arrays.stream((ActivateScopes.All[])target.getAnnotationsByType(ActivateScopes.All.class)).flatMap(o -> Arrays.stream(o.value())).flatMap(o -> Arrays.stream(o.value())).forEachOrdered(scopes::add);
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    @Qualifier
    static @interface DeactivateContexts {

        public static final class Literal
        extends AnnotationLiteral<DeactivateContexts>
        implements ActivateContexts {
            private static final long serialVersionUID = 1L;
            public static final ActivateContexts.Literal INSTANCE = new ActivateContexts.Literal();
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    @Qualifier
    static @interface ActivateContexts {

        public static final class Literal
        extends AnnotationLiteral<ActivateContexts>
        implements ActivateContexts {
            private static final long serialVersionUID = 1L;
            public static final Literal INSTANCE = new Literal();
        }
    }
}

