/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdiunit.internal.activatescopes;

import jakarta.enterprise.context.ContextNotActiveException;
import jakarta.enterprise.context.Destroyed;
import jakarta.enterprise.context.Initialized;
import jakarta.enterprise.context.spi.Context;
import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.spi.BeanManager;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CdiContext
implements Context {
    private static final Logger logger = LoggerFactory.getLogger(CdiContext.class);
    private final Class<? extends Annotation> scope;
    private final BeanManager beanManager;
    private final ThreadLocal<Map<Contextual<?>, ContextualInstance<?>>> currentContext = new ThreadLocal();

    CdiContext(Class<? extends Annotation> scope, BeanManager beanManager) {
        this.scope = scope;
        this.beanManager = beanManager;
    }

    public Class<? extends Annotation> getScope() {
        return this.scope;
    }

    public <T> T get(Contextual<T> contextual, CreationalContext<T> creationalContext) {
        Map<Contextual<?>, ContextualInstance<?>> ctx = this.currentContext.get();
        if (ctx == null) {
            throw new ContextNotActiveException();
        }
        ContextualInstance<Object> instance = ctx.get(contextual);
        if (instance == null && creationalContext != null) {
            instance = new ContextualInstance<Object>(contextual.create(creationalContext), creationalContext, contextual);
            ctx.put(contextual, instance);
        }
        return instance != null ? (T)instance.get() : null;
    }

    public <T> T get(Contextual<T> contextual) {
        return this.get(contextual, null);
    }

    public boolean isActive() {
        return this.currentContext.get() != null;
    }

    public void activate() {
        this.currentContext.set(new HashMap());
        this.beanManager.getEvent().select(new Annotation[]{Initialized.Literal.of(this.scope)}).fire(new Object());
    }

    public void deactivate() {
        Map<Contextual<?>, ContextualInstance<?>> ctx = this.currentContext.get();
        if (ctx == null) {
            return;
        }
        for (ContextualInstance<?> instance : ctx.values()) {
            try {
                instance.destroy();
            }
            catch (Exception e) {
                logger.warn("Unable to destroy instance {} for bean: {}", instance.get(), instance.getContextual());
            }
        }
        ctx.clear();
        this.currentContext.remove();
        this.beanManager.getEvent().select(new Annotation[]{Destroyed.Literal.of(this.scope)}).fire(new Object());
    }

    static final class ContextualInstance<T> {
        private final T value;
        private final CreationalContext<T> creationalContext;
        private final Contextual<T> contextual;

        ContextualInstance(T instance, CreationalContext<T> creationalContext, Contextual<T> contextual) {
            this.value = instance;
            this.creationalContext = creationalContext;
            this.contextual = contextual;
        }

        T get() {
            return this.value;
        }

        Contextual<T> getContextual() {
            return this.contextual;
        }

        void destroy() {
            this.contextual.destroy(this.value, this.creationalContext);
        }
    }
}

