/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdiunit.internal;

import io.github.cdiunit.Isolation;
import io.github.cdiunit.IsolationLevel;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;

public class TestConfiguration {
    private final Class<?> testClass;
    private Method testMethod;
    private final Collection<Class<?>> additionalClasses;
    private final IsolationLevel isolationLevel;

    public TestConfiguration(Class<?> testClass, Method testMethod, Collection<Class<?>> additionalClasses) {
        this.testClass = testClass;
        this.testMethod = testMethod;
        if (additionalClasses == null) {
            throw new NullPointerException("Expected AdditionalClasses not null.");
        }
        this.additionalClasses = additionalClasses;
        this.isolationLevel = TestConfiguration.getIsolationLevel(testClass);
    }

    public TestConfiguration(Class<?> testClass, Method testMethod) {
        this(testClass, testMethod, Collections.emptySet());
    }

    public Class<?> getTestClass() {
        return this.testClass;
    }

    public Method getTestMethod() {
        return this.testMethod;
    }

    public void setTestMethod(Method testMethod) {
        this.testMethod = testMethod;
    }

    public Collection<Class<?>> getAdditionalClasses() {
        return this.additionalClasses;
    }

    public IsolationLevel getIsolationLevel() {
        return this.isolationLevel;
    }

    private static IsolationLevel getIsolationLevel(Class<?> testClass) {
        Isolation isolation = testClass.getAnnotation(Isolation.class);
        return isolation == null ? IsolationLevel.PER_METHOD : isolation.value();
    }
}

