/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdiunit.internal;

import io.github.cdiunit.ProducesAlternative;
import io.github.cdiunit.internal.ClasspathScanner;
import io.github.cdiunit.internal.DiscoveryExtension;
import io.github.cdiunit.internal.ExceptionUtils;
import io.github.cdiunit.internal.TestConfiguration;
import jakarta.enterprise.inject.spi.Extension;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.jboss.weld.environment.se.Weld;
import org.jboss.weld.environment.se.WeldSEBeanRegistrant;

class DefaultDiscoveryContext
implements DiscoveryExtension.Context {
    private final ClasspathScanner scanner;
    private final TestConfiguration testConfiguration;
    private final Set<Extension> extensions = new LinkedHashSet<Extension>();
    private final Set<Class<?>> classesToProcess = new LinkedHashSet();
    private final Set<Class<?>> classesToIgnore = new LinkedHashSet();
    private final Set<Class<?>> alternatives = new LinkedHashSet();
    private final Set<Class<?>> decorators = new LinkedHashSet();
    private final Set<Class<?>> interceptors = new LinkedHashSet();
    private final Set<Class<? extends Annotation>> alternativeStereotypes = new LinkedHashSet<Class<? extends Annotation>>();

    public DefaultDiscoveryContext(ClasspathScanner scanner, TestConfiguration testConfiguration) {
        this.scanner = scanner;
        this.testConfiguration = testConfiguration;
    }

    @Override
    public TestConfiguration getTestConfiguration() {
        return this.testConfiguration;
    }

    public boolean hasClassesToProcess() {
        return !this.classesToProcess.isEmpty();
    }

    public Class<?> nextClassToProcess() {
        return this.classesToProcess.iterator().next();
    }

    public void processed(Class<?> c) {
        this.classesToProcess.remove(c);
    }

    private void process(Type type, Consumer<Class<?>> onClass) {
        if (type instanceof Class) {
            onClass.accept((Class)type);
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType ptype = (ParameterizedType)type;
            onClass.accept((Class)ptype.getRawType());
            for (Type arg : ptype.getActualTypeArguments()) {
                this.process(arg, onClass);
            }
        }
    }

    @Override
    public void processBean(String className) {
        this.processBean(this.loadClass(className));
    }

    @Override
    public void processBean(Type type) {
        this.process(type, this.classesToProcess::add);
    }

    @Override
    public void ignoreBean(String className) {
        this.ignoreBean(this.loadClass(className));
    }

    @Override
    public void ignoreBean(Type type) {
        this.process(type, this.classesToIgnore::add);
    }

    public boolean isIgnored(Class<?> c) {
        return this.classesToIgnore.contains(c);
    }

    @Override
    public void enableAlternative(String className) {
        this.alternatives.add(this.loadClass(className));
    }

    @Override
    public void enableAlternative(Class<?> alternativeClass) {
        this.alternatives.add(alternativeClass);
    }

    public Collection<Class<?>> getAlternatives() {
        return this.alternatives;
    }

    @Override
    public void enableDecorator(String className) {
        this.decorators.add(this.loadClass(className));
    }

    @Override
    public void enableDecorator(Class<?> decoratorClass) {
        this.decorators.add(decoratorClass);
    }

    public Collection<Class<?>> getDecorators() {
        return this.decorators;
    }

    @Override
    public void enableInterceptor(String className) {
        this.interceptors.add(this.loadClass(className));
    }

    @Override
    public void enableInterceptor(Class<?> interceptorClass) {
        this.interceptors.add(interceptorClass);
    }

    public Collection<Class<?>> getInterceptors() {
        return this.interceptors;
    }

    @Override
    public void enableAlternativeStereotype(String className) {
        this.alternativeStereotypes.add(this.loadClass(className));
    }

    @Override
    public void enableAlternativeStereotype(Class<? extends Annotation> alternativeStereotypeClass) {
        this.alternativeStereotypes.add(alternativeStereotypeClass);
    }

    public Collection<Class<? extends Annotation>> getAlternativeStereotypes() {
        return this.alternativeStereotypes;
    }

    @Override
    public void extension(Extension extension) {
        this.extensions.add(extension);
    }

    public Collection<Extension> getExtensions() {
        return this.extensions;
    }

    @Override
    public Collection<Class<?>> scanPackages(Collection<Class<?>> baseClasses) {
        LinkedHashSet result = new LinkedHashSet();
        for (Class<?> baseClass : baseClasses) {
            String packageName = baseClass.getPackage().getName();
            URL url = this.scanner.getClasspathURL(baseClass);
            this.scanner.getClassNamesForPackage(packageName, url).stream().map(this::loadClass).collect(Collectors.toCollection(() -> result));
        }
        return result;
    }

    @Override
    public Collection<Class<?>> scanBeanArchives(Collection<Class<?>> baseClasses) {
        URL[] urls = (URL[])baseClasses.stream().map(this.scanner::getClasspathURL).toArray(URL[]::new);
        return this.scanner.getClassNamesForClasspath(urls).stream().map(this::loadClass).collect(Collectors.toSet());
    }

    private Class<?> loadClass(String name) {
        try {
            return this.getClass().getClassLoader().loadClass(name);
        }
        catch (ClassNotFoundException e) {
            throw ExceptionUtils.asRuntimeException(e);
        }
    }

    void configure(Weld weld) {
        weld.addExtension((Extension)new WeldSEBeanRegistrant());
        weld.addAlternativeStereotype(ProducesAlternative.class);
        weld.addBeanClass(this.testConfiguration.getTestClass());
        this.extensions.forEach(arg_0 -> ((Weld)weld).addExtension(arg_0));
        this.alternatives.forEach(arg_0 -> ((Weld)weld).addAlternative(arg_0));
        this.alternativeStereotypes.forEach(arg_0 -> ((Weld)weld).addAlternativeStereotype(arg_0));
        this.decorators.forEach(arg_0 -> ((Weld)weld).addDecorator(arg_0));
        this.interceptors.forEach(arg_0 -> ((Weld)weld).addInterceptor(arg_0));
    }
}

