/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdiunit.internal;

import io.github.cdiunit.internal.BeanArchiveScanner;
import io.github.cdiunit.internal.ClasspathScanner;
import io.github.cdiunit.internal.ExceptionUtils;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ScanResult;
import java.net.URL;
import java.util.Collection;
import java.util.List;

class ClassGraphScanner
implements ClasspathScanner {
    private final BeanArchiveScanner beanArchiveScanner;

    ClassGraphScanner(BeanArchiveScanner beanArchiveScanner) {
        this.beanArchiveScanner = beanArchiveScanner;
    }

    private List<URL> getClasspathURLs() {
        try (ScanResult scan = new ClassGraph().disableNestedJarScanning().scan();){
            List list = scan.getClasspathURLs();
            return list;
        }
    }

    @Override
    public Collection<URL> getBeanArchives() {
        List<URL> urls = this.getClasspathURLs();
        try {
            return this.beanArchiveScanner.findBeanArchives(urls);
        }
        catch (Exception e) {
            throw ExceptionUtils.asRuntimeException(e);
        }
    }

    @Override
    public List<String> getClassNamesForClasspath(URL[] urls) {
        try (ScanResult scan = new ClassGraph().disableNestedJarScanning().enableClassInfo().ignoreClassVisibility().overrideClasspath((Object[])urls).scan();){
            List list = scan.getAllClasses().getNames();
            return list;
        }
    }

    @Override
    public List<String> getClassNamesForPackage(String packageName, URL url) {
        try (ScanResult scan = new ClassGraph().disableNestedJarScanning().enableClassInfo().ignoreClassVisibility().overrideClasspath(new Object[]{url}).acceptPackagesNonRecursive(new String[]{packageName}).scan();){
            List list = scan.getAllClasses().getNames();
            return list;
        }
    }
}

