/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdiunit;

import io.github.cdiunit.internal.QuietDiscovery;
import io.github.cdiunit.internal.servlet.CdiUnitInitialListener;
import io.github.cdiunit.internal.servlet.LifecycleAwareRequest;
import io.github.cdiunit.internal.servlet.common.CdiUnitServlet;
import io.github.cdiunit.internal.servlet.common.HttpSessionAware;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletContextEvent;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletRequestEvent;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.http.HttpSessionEvent;
import org.jboss.weld.context.ConversationContext;
import org.jboss.weld.context.http.Http;

@ApplicationScoped
@QuietDiscovery
public class ContextController {
    private ThreadLocal<HttpServletRequest> requests;
    private HttpSession currentSession;
    @Inject
    @CdiUnitServlet
    private ServletContext context;
    @Inject
    private CdiUnitInitialListener listener;
    @Inject
    @CdiUnitServlet
    private Provider<HttpServletRequest> requestProvider;
    @Inject
    @Http
    private ConversationContext conversationContext;

    @PostConstruct
    void initContext() {
        this.requests = new ThreadLocal();
        this.listener.contextInitialized(new ServletContextEvent(this.context));
    }

    @PreDestroy
    void destroyContext() {
        this.listener.contextDestroyed(new ServletContextEvent(this.context));
        this.requests = null;
    }

    public HttpServletRequest openRequest() {
        Object currentRequest = this.requests.get();
        if (currentRequest != null) {
            throw new RuntimeException("A request is already open");
        }
        HttpServletRequest request = (HttpServletRequest)this.requestProvider.get();
        if (this.currentSession != null) {
            if (request instanceof HttpSessionAware) {
                ((HttpSessionAware)request).setSession(this.currentSession);
            }
            request.getSession();
        }
        currentRequest = new LifecycleAwareRequest(this.listener, request);
        this.requests.set((HttpServletRequest)currentRequest);
        this.listener.requestInitialized(new ServletRequestEvent(this.context, (ServletRequest)currentRequest));
        if (!this.conversationContext.isActive()) {
            this.conversationContext.activate();
        }
        return currentRequest;
    }

    public HttpServletRequest currentRequest() {
        HttpServletRequest currentRequest = this.requests.get();
        if (currentRequest == null) {
            throw new RuntimeException("A request has not been opened");
        }
        return currentRequest;
    }

    public void closeRequest() {
        HttpServletRequest currentRequest = this.requests.get();
        if (currentRequest != null) {
            this.listener.requestDestroyed(new ServletRequestEvent(this.context, (ServletRequest)currentRequest));
            this.currentSession = currentRequest.getSession(false);
        }
        this.requests.remove();
    }

    public void closeSession() {
        HttpServletRequest currentRequest = this.requests.get();
        if (currentRequest != null) {
            this.currentSession = currentRequest.getSession(false);
        }
        if (this.currentSession != null) {
            this.listener.sessionDestroyed(new HttpSessionEvent(this.currentSession));
            this.currentSession = null;
        }
    }

    public HttpSession getSession() {
        return this.currentSession;
    }
}

