/*
 * Decompiled with CFR 0.152.
 */
package com.cdancy.jenkins.rest.parsers;

import com.cdancy.jenkins.rest.domain.crumb.Crumb;
import com.google.common.base.Function;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import javax.inject.Singleton;
import org.jclouds.http.HttpResponse;
import org.jclouds.util.Strings2;

@Singleton
public class CrumbParser
implements Function<HttpResponse, Crumb> {
    public Crumb apply(HttpResponse input) {
        if (input == null) {
            throw new RuntimeException("Unexpected NULL HttpResponse object");
        }
        int statusCode = input.getStatusCode();
        if (statusCode >= 200 && statusCode < 400) {
            try {
                return Crumb.create(CrumbParser.crumbValue(input), CrumbParser.sessionIdCookie(input));
            }
            catch (IOException e) {
                throw new RuntimeException(input.getStatusLine(), e);
            }
        }
        throw new RuntimeException(input.getStatusLine());
    }

    private static String crumbValue(HttpResponse input) throws IOException {
        return Strings2.toStringAndClose((InputStream)input.getPayload().openStream()).split(":")[1];
    }

    private static String sessionIdCookie(HttpResponse input) {
        return CrumbParser.setCookieValues(input).stream().filter(c -> c.startsWith("JSESSIONID")).findFirst().orElse("");
    }

    private static Collection<String> setCookieValues(HttpResponse input) {
        Collection setCookieValues = input.getHeaders().get((Object)"Set-Cookie");
        if (setCookieValues.isEmpty()) {
            return input.getHeaders().get((Object)"Set-Cookie".toLowerCase());
        }
        return setCookieValues;
    }
}

