/*
 * Decompiled with CFR 0.152.
 */
package com.cdancy.jenkins.rest.filters;

import com.cdancy.jenkins.rest.JenkinsAuthentication;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.http.HttpException;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpRequestFilter;

@Singleton
public class JenkinsUserInjectionFilter
implements HttpRequestFilter {
    private static final String USER_PLACE_HOLDER = "%7Buser%7D";
    private final JenkinsAuthentication creds;

    @Inject
    public JenkinsUserInjectionFilter(JenkinsAuthentication creds) {
        this.creds = creds;
    }

    public HttpRequest filter(HttpRequest request) throws HttpException {
        String requestPath = request.getEndpoint().getRawPath().replaceAll(USER_PLACE_HOLDER, this.creds.identity);
        return request.toBuilder().fromHttpRequest(request).replacePath(requestPath).build();
    }
}

