/*
 * Decompiled with CFR 0.152.
 */
package com.cdancy.jenkins.rest.filters;

import com.cdancy.jenkins.rest.JenkinsAuthentication;
import com.cdancy.jenkins.rest.auth.AuthenticationType;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.http.HttpException;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpRequestFilter;

@Singleton
public class JenkinsNoCrumbAuthenticationFilter
implements HttpRequestFilter {
    private final JenkinsAuthentication creds;

    @Inject
    JenkinsNoCrumbAuthenticationFilter(JenkinsAuthentication creds) {
        this.creds = creds;
    }

    public HttpRequest filter(HttpRequest request) throws HttpException {
        if (this.creds.authType() == AuthenticationType.Anonymous) {
            return request;
        }
        String authHeader = this.creds.authType().getAuthScheme() + " " + this.creds.authValue();
        return ((HttpRequest.Builder)request.toBuilder().addHeader("Authorization", new String[]{authHeader})).build();
    }
}

