/*
 * Decompiled with CFR 0.152.
 */
package com.cdancy.jenkins.rest;

import com.cdancy.jenkins.rest.auth.AuthenticationType;
import com.cdancy.jenkins.rest.exception.UndetectableIdentityException;
import com.google.common.io.BaseEncoding;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.jclouds.domain.Credentials;
import org.jclouds.javax.annotation.Nullable;

public class JenkinsAuthentication
extends Credentials {
    private final AuthenticationType authType;

    private JenkinsAuthentication(String identity, String credential, AuthenticationType authType) {
        super(identity, credential.contains(":") ? BaseEncoding.base64().encode(credential.getBytes()) : credential);
        this.authType = authType;
    }

    @Nullable
    public String authValue() {
        return this.credential;
    }

    public AuthenticationType authType() {
        return this.authType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String identity = "anonymous";
        private String credential = this.identity + ":";
        private AuthenticationType authType = AuthenticationType.Anonymous;

        public Builder credentials(String usernamePassword) {
            this.identity = Objects.requireNonNull(this.extractIdentity(usernamePassword));
            this.credential = Objects.requireNonNull(usernamePassword);
            this.authType = AuthenticationType.UsernamePassword;
            return this;
        }

        public Builder apiToken(String apiTokenCredentials) {
            this.identity = Objects.requireNonNull(this.extractIdentity(apiTokenCredentials));
            this.credential = Objects.requireNonNull(apiTokenCredentials);
            this.authType = AuthenticationType.UsernameApiToken;
            return this;
        }

        private String extractIdentity(String credentialString) {
            String decoded = !credentialString.contains(":") ? new String(BaseEncoding.base64().decode((CharSequence)credentialString), StandardCharsets.UTF_8) : credentialString;
            if (!decoded.contains(":")) {
                throw new UndetectableIdentityException("Unable to detect the identity being used in '" + credentialString + "'. Supported types are a user:password, or a user:apiToken, or their base64 encoded value.");
            }
            if (decoded.equals(":")) {
                return "";
            }
            return decoded.split(":")[0];
        }

        public JenkinsAuthentication build() {
            return new JenkinsAuthentication(this.identity, this.credential, this.authType);
        }
    }
}

