/*
 * Decompiled with CFR 0.152.
 */
package com.cdancy.jenkins.rest.parsers;

import com.google.common.base.Function;
import javax.inject.Singleton;

@Singleton
public class FolderPathParser
implements Function<Object, String> {
    public static final String EMPTY_STRING = "";
    public static final String FOLDER_NAME_PREFIX = "job/";
    public static final Character FOLDER_NAME_SEPARATOR = Character.valueOf('/');

    public String apply(Object folderPath) {
        StringBuilder path = new StringBuilder((String)folderPath);
        if (path.length() == 0) {
            return EMPTY_STRING;
        }
        if (path.charAt(0) == FOLDER_NAME_SEPARATOR.charValue()) {
            path.deleteCharAt(0);
        }
        if (path.charAt(path.length() - 1) == FOLDER_NAME_SEPARATOR.charValue()) {
            path.deleteCharAt(path.length() - 1);
        }
        String[] folders = path.toString().split(Character.toString(FOLDER_NAME_SEPARATOR.charValue()));
        path.setLength(0);
        for (String folder : folders) {
            path.append(FOLDER_NAME_PREFIX).append(folder).append(FOLDER_NAME_SEPARATOR);
        }
        return path.toString();
    }
}

