/*
 * Decompiled with CFR 0.152.
 */
package com.cdancy.jenkins.rest.filters;

import com.cdancy.jenkins.rest.JenkinsApi;
import com.cdancy.jenkins.rest.JenkinsAuthentication;
import com.cdancy.jenkins.rest.auth.AuthenticationType;
import com.cdancy.jenkins.rest.domain.crumb.Crumb;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.http.HttpException;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpRequestFilter;
import org.jclouds.rest.ResourceNotFoundException;

@Singleton
public class JenkinsAuthenticationFilter
implements HttpRequestFilter {
    private final JenkinsAuthentication creds;
    private final JenkinsApi jenkinsApi;
    private volatile Pair<Crumb, Boolean> crumbPair = null;
    private static final String CRUMB_HEADER = "Jenkins-Crumb";

    @Inject
    JenkinsAuthenticationFilter(JenkinsAuthentication creds, JenkinsApi jenkinsApi) {
        this.creds = creds;
        this.jenkinsApi = jenkinsApi;
    }

    public HttpRequest filter(HttpRequest request) throws HttpException {
        if (this.creds.authType() == AuthenticationType.Anonymous) {
            return request;
        }
        String authHeader = (Object)((Object)this.creds.authType()) + " " + this.creds.authValue();
        HttpRequest.Builder builder = request.toBuilder();
        builder.addHeader("Authorization", new String[]{authHeader});
        Pair<Crumb, Boolean> localCrumb = this.getCrumb();
        if (localCrumb.getKey().value() != null) {
            builder.addHeader(CRUMB_HEADER, new String[]{localCrumb.getKey().value()});
            Optional.ofNullable(localCrumb.getKey().sessionIdCookie()).ifPresent(sessionId -> {
                HttpRequest.Builder cfr_ignored_0 = (HttpRequest.Builder)builder.addHeader("Cookie", new String[]{sessionId});
            });
        } else if (!localCrumb.getValue().booleanValue()) {
            throw new RuntimeException("Unexpected exception being thrown: error=" + localCrumb.getKey().errors().get(0));
        }
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Pair<Crumb, Boolean> getCrumb() {
        Pair<Crumb, Boolean> crumbValueInit = this.crumbPair;
        if (crumbValueInit == null) {
            JenkinsAuthenticationFilter jenkinsAuthenticationFilter = this;
            synchronized (jenkinsAuthenticationFilter) {
                crumbValueInit = this.crumbPair;
                if (crumbValueInit == null) {
                    Crumb crumb = this.jenkinsApi.crumbIssuerApi().crumb();
                    Boolean isRNFE = crumb.errors().isEmpty() ? true : crumb.errors().get(0).exceptionName().endsWith(ResourceNotFoundException.class.getSimpleName());
                    this.crumbPair = crumbValueInit = new Pair<Crumb, Boolean>(crumb, isRNFE);
                }
            }
        }
        return crumbValueInit;
    }

    private class Pair<A, B> {
        private final A a;
        private final B b;

        public Pair(A a, B b) {
            this.a = a;
            this.b = b;
        }

        public A getKey() {
            return this.a;
        }

        public B getValue() {
            return this.b;
        }
    }
}

