/*
 * Decompiled with CFR 0.152.
 */
package com.cdancy.jenkins.rest.fallbacks;

import com.cdancy.jenkins.rest.domain.common.Error;
import com.cdancy.jenkins.rest.domain.common.IntegerResponse;
import com.cdancy.jenkins.rest.domain.common.RequestStatus;
import com.cdancy.jenkins.rest.domain.crumb.Crumb;
import com.cdancy.jenkins.rest.domain.plugins.Plugins;
import com.cdancy.jenkins.rest.domain.system.SystemInfo;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.jclouds.Fallback;
import org.jclouds.rest.ResourceNotFoundException;

public final class JenkinsFallbacks {
    public static SystemInfo createSystemInfoFromErrors(List<Error> errors) {
        String illegalValue = "-1";
        return SystemInfo.create("-1", "-1", "-1", "-1", "-1", "-1", errors);
    }

    public static List<Error> getErrors(Exception output) {
        Error error = Error.create(null, output.getMessage(), output.getClass().getName());
        return Lists.newArrayList((Object[])new Error[]{error});
    }

    public static List<Error> getErrors(Throwable output) {
        ArrayList errors = Lists.newArrayList();
        String context = null;
        String message = output.getMessage();
        String[] messageParts = output.getMessage().split("->");
        switch (messageParts.length) {
            case 1: {
                message = messageParts[0].trim();
                break;
            }
            case 3: {
                context = messageParts[0].trim();
                message = messageParts[2].trim();
            }
        }
        Error error = Error.create(context, message, output.getClass().getCanonicalName());
        errors.add(error);
        return errors;
    }

    public static final class JENKINS_21311
    implements Fallback<Object> {
        public Object createOrPropagate(Throwable throwable) throws Exception {
            if (Preconditions.checkNotNull((Object)throwable, (Object)"throwable") != null) {
                try {
                    if (throwable.getClass() == ResourceNotFoundException.class) {
                        return RequestStatus.create(true, null);
                    }
                    return RequestStatus.create(false, JenkinsFallbacks.getErrors(throwable));
                }
                catch (JsonSyntaxException e) {
                    return RequestStatus.create(false, JenkinsFallbacks.getErrors((Exception)((Object)e)));
                }
            }
            throw Throwables.propagate((Throwable)throwable);
        }
    }

    public static final class PluginsOnError
    implements Fallback<Object> {
        public Object createOrPropagate(Throwable throwable) throws Exception {
            if (Preconditions.checkNotNull((Object)throwable, (Object)"throwable") != null) {
                try {
                    return Plugins.create(null, null, JenkinsFallbacks.getErrors(throwable));
                }
                catch (JsonSyntaxException e) {
                    return Plugins.create(null, null, JenkinsFallbacks.getErrors((Exception)((Object)e)));
                }
            }
            throw Throwables.propagate((Throwable)throwable);
        }
    }

    public static final class CrumbOnError
    implements Fallback<Object> {
        public Object createOrPropagate(Throwable throwable) throws Exception {
            if (Preconditions.checkNotNull((Object)throwable, (Object)"throwable") != null) {
                try {
                    return Crumb.create(null, JenkinsFallbacks.getErrors(throwable));
                }
                catch (JsonSyntaxException e) {
                    return Crumb.create(null, JenkinsFallbacks.getErrors((Exception)((Object)e)));
                }
            }
            throw Throwables.propagate((Throwable)throwable);
        }
    }

    public static final class IntegerResponseOnError
    implements Fallback<Object> {
        public Object createOrPropagate(Throwable throwable) throws Exception {
            if (Preconditions.checkNotNull((Object)throwable, (Object)"throwable") != null) {
                try {
                    return IntegerResponse.create(null, JenkinsFallbacks.getErrors(throwable));
                }
                catch (JsonSyntaxException e) {
                    return IntegerResponse.create(null, JenkinsFallbacks.getErrors((Exception)((Object)e)));
                }
            }
            throw Throwables.propagate((Throwable)throwable);
        }
    }

    public static final class RequestStatusOnError
    implements Fallback<Object> {
        public Object createOrPropagate(Throwable throwable) throws Exception {
            if (Preconditions.checkNotNull((Object)throwable, (Object)"throwable") != null) {
                try {
                    return RequestStatus.create(false, JenkinsFallbacks.getErrors(throwable));
                }
                catch (JsonSyntaxException e) {
                    return RequestStatus.create(false, JenkinsFallbacks.getErrors((Exception)((Object)e)));
                }
            }
            throw Throwables.propagate((Throwable)throwable);
        }
    }

    public static final class SystemInfoOnError
    implements Fallback<Object> {
        public Object createOrPropagate(Throwable throwable) throws Exception {
            if (Preconditions.checkNotNull((Object)throwable, (Object)"throwable") != null) {
                return JenkinsFallbacks.createSystemInfoFromErrors(JenkinsFallbacks.getErrors(throwable));
            }
            throw Throwables.propagate((Throwable)throwable);
        }
    }
}

