/*
 * Decompiled with CFR 0.152.
 */
package com.cdancy.jenkins.rest;

import com.cdancy.jenkins.rest.JenkinsAuthentication;
import com.cdancy.jenkins.rest.JenkinsConstants;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.jclouds.javax.annotation.Nullable;

public class JenkinsUtils {
    public static final Gson GSON_PARSER = new Gson();
    public static final JsonParser JSON_PARSER = new JsonParser();

    public static <T> List<T> nullToEmpty(Iterable<? extends T> input) {
        return input == null ? ImmutableList.of() : ImmutableList.copyOf(input);
    }

    public static <K, V> Map<K, V> nullToEmpty(Map<? extends K, ? extends V> input) {
        return input == null ? ImmutableMap.of() : ImmutableMap.copyOf(input);
    }

    public static JsonElement nullToJsonElement(Map input) {
        return GSON_PARSER.toJsonTree(JenkinsUtils.nullToEmpty(input));
    }

    public static JsonElement nullToJsonElement(JsonElement input) {
        return input != null ? input : GSON_PARSER.toJsonTree((Object)ImmutableMap.of());
    }

    public static JsonElement nullToJsonElement(String input) {
        return JSON_PARSER.parse(input != null ? input : "{}");
    }

    public static String retriveExternalValue(@Nullable String systemProperty, @Nullable String environmentVariable) {
        String value;
        if (systemProperty != null && (value = System.getProperty(systemProperty)) != null) {
            return value;
        }
        if (environmentVariable != null && (value = System.getenv(environmentVariable)) != null) {
            return value;
        }
        return null;
    }

    public static String inferEndpoint() {
        String possibleValue = JenkinsUtils.retriveExternalValue("jenkins.rest.endpoint", JenkinsConstants.ENDPOINT_ENVIRONMENT_VARIABLE);
        return possibleValue != null ? possibleValue : "http://127.0.0.1:7990";
    }

    public static JenkinsAuthentication inferAuthentication() {
        JenkinsAuthentication.Builder inferAuth = JenkinsAuthentication.builder();
        String authValue = JenkinsUtils.retriveExternalValue("jenkins.rest.credentials", JenkinsConstants.CREDENTIALS_ENVIRONMENT_VARIABLE);
        if (authValue != null) {
            inferAuth.credentials(authValue);
        } else {
            authValue = JenkinsUtils.retriveExternalValue("jenkins.rest.token", JenkinsConstants.TOKEN_ENVIRONMENT_VARIABLE);
            if (authValue != null) {
                inferAuth.token(authValue);
            }
        }
        return inferAuth.build();
    }

    public static Properties inferOverrides() {
        Properties overrides = new Properties();
        Properties systemProperties = System.getProperties();
        Enumeration<?> enums = systemProperties.propertyNames();
        while (enums.hasMoreElements()) {
            String key = (String)enums.nextElement();
            if (!key.startsWith("jenkins.rest.jclouds.")) continue;
            int index = key.indexOf("jclouds.");
            String trimmedKey = key.substring(index, key.length());
            overrides.put(trimmedKey, systemProperties.getProperty(key));
        }
        for (Map.Entry<String, String> entry : System.getenv().entrySet()) {
            if (!entry.getKey().startsWith("JENKINS_REST_JCLOUDS_")) continue;
            int index = entry.getKey().indexOf("JCLOUDS_");
            String trimmedKey = entry.getKey().substring(index, entry.getKey().length()).toLowerCase().replaceAll("_", ".");
            if (overrides.containsKey(trimmedKey)) continue;
            overrides.put(trimmedKey, entry.getValue());
        }
        return overrides;
    }

    public static void addEnvironmentVariables(Map<String, String> addEnvVars) {
        Objects.requireNonNull(addEnvVars, "Must pass non-null Map");
        HashMap newenv = Maps.newHashMap(System.getenv());
        newenv.putAll(addEnvVars);
        JenkinsUtils.setEnvironmentVariables(newenv);
    }

    public static void removeEnvironmentVariables(Collection<String> removeEnvVars) {
        Objects.requireNonNull(removeEnvVars, "Must pass non-null Collection");
        HashMap newenv = Maps.newHashMap(System.getenv());
        newenv.keySet().removeAll(removeEnvVars);
        JenkinsUtils.setEnvironmentVariables(newenv);
    }

    public static void setEnvironmentVariables(Map<String, String> newEnvVars) {
        Objects.requireNonNull(newEnvVars, "Must pass non-null Map");
        try {
            Class<?> processEnvironmentClass = Class.forName("java.lang.ProcessEnvironment");
            Field theEnvironmentField = processEnvironmentClass.getDeclaredField("theEnvironment");
            theEnvironmentField.setAccessible(true);
            Map env = (Map)theEnvironmentField.get(null);
            env.putAll(newEnvVars);
            Field theCaseInsensitiveEnvironmentField = processEnvironmentClass.getDeclaredField("theCaseInsensitiveEnvironment");
            theCaseInsensitiveEnvironmentField.setAccessible(true);
            Map cienv = (Map)theCaseInsensitiveEnvironmentField.get(null);
            cienv.putAll(newEnvVars);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            Class<?>[] classes = Collections.class.getDeclaredClasses();
            Map<String, String> env = System.getenv();
            for (Class<?> cl : classes) {
                if (!"java.util.Collections$UnmodifiableMap".equals(cl.getName())) continue;
                try {
                    Field field = cl.getDeclaredField("m");
                    field.setAccessible(true);
                    Object obj = field.get(env);
                    Map map = (Map)obj;
                    map.clear();
                    map.putAll(newEnvVars);
                }
                catch (IllegalAccessException | NoSuchFieldException e2) {
                    throw Throwables.propagate((Throwable)e2);
                }
            }
        }
    }

    protected JenkinsUtils() {
        throw new UnsupportedOperationException("Purposefully not implemented");
    }
}

