/*
 * Decompiled with CFR 0.152.
 */
package com.cdancy.bitbucket.rest.parsers;

import com.cdancy.bitbucket.rest.domain.file.RawContent;
import com.google.common.base.Function;
import com.google.common.base.Throwables;
import java.io.InputStream;
import javax.inject.Singleton;
import org.jclouds.http.HttpResponse;
import org.jclouds.util.Strings2;

@Singleton
public class RawContentParser
implements Function<HttpResponse, RawContent> {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RawContent apply(HttpResponse input) {
        try (InputStream inputStream = input.getPayload().openStream();){
            String value = Strings2.toStringAndClose((InputStream)inputStream);
            RawContent rawContent = RawContent.create(value, null);
            return rawContent;
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

