/*
 * Decompiled with CFR 0.152.
 */
package com.cdancy.bitbucket.rest.parsers;

import com.cdancy.bitbucket.rest.BitbucketUtils;
import com.cdancy.bitbucket.rest.domain.repository.HookSettings;
import com.google.common.base.Function;
import com.google.common.base.Throwables;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.io.InputStream;
import javax.inject.Singleton;
import org.jclouds.http.HttpResponse;
import org.jclouds.util.Strings2;

@Singleton
public class HookSettingsParser
implements Function<HttpResponse, HookSettings> {
    public HookSettings apply(HttpResponse input) {
        int statusCode = input.getStatusCode();
        try {
            String payload;
            switch (statusCode) {
                case 200: {
                    payload = Strings2.toStringAndClose((InputStream)input.getPayload().openStream());
                    break;
                }
                case 204: {
                    payload = null;
                    break;
                }
                default: {
                    throw new RuntimeException(input.getStatusLine());
                }
            }
            JsonElement settings = BitbucketUtils.nullToJsonElement(payload);
            return HookSettings.of(settings);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

