/*
 * Decompiled with CFR 0.152.
 */
package com.cdancy.bitbucket.rest.features;

import com.cdancy.bitbucket.rest.annotations.Documentation;
import com.cdancy.bitbucket.rest.domain.common.RequestStatus;
import com.cdancy.bitbucket.rest.domain.repository.PermissionsPage;
import com.cdancy.bitbucket.rest.domain.repository.PullRequestSettings;
import com.cdancy.bitbucket.rest.domain.repository.Repository;
import com.cdancy.bitbucket.rest.domain.repository.RepositoryPage;
import com.cdancy.bitbucket.rest.fallbacks.BitbucketFallbacks;
import com.cdancy.bitbucket.rest.filters.BitbucketAuthenticationFilter;
import com.cdancy.bitbucket.rest.options.CreatePullRequestSettings;
import com.cdancy.bitbucket.rest.options.CreateRepository;
import com.cdancy.bitbucket.rest.parsers.DeleteRepositoryParser;
import com.cdancy.bitbucket.rest.parsers.RequestStatusParser;
import com.google.inject.name.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.Payload;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.binders.BindToJsonPayload;

@Produces(value={"application/json"})
@RequestFilters(value={BitbucketAuthenticationFilter.class})
@Path(value="/rest/api/{jclouds.api-version}")
public interface RepositoryApi {
    @Named(value="repository:create")
    @Documentation(value={"https://developer.atlassian.com/static/rest/bitbucket-server/latest/bitbucket-rest.html#idm45888277587248"})
    @Consumes(value={"application/json"})
    @Path(value="/projects/{project}/repos")
    @Fallback(value=BitbucketFallbacks.RepositoryOnError.class)
    @POST
    public Repository create(@PathParam(value="project") String var1, @BinderParam(value=BindToJsonPayload.class) CreateRepository var2);

    @Named(value="repository:get")
    @Documentation(value={"https://developer.atlassian.com/static/rest/bitbucket-server/latest/bitbucket-rest.html#idm45888277593152"})
    @Consumes(value={"application/json"})
    @Path(value="/projects/{project}/repos/{repo}")
    @Fallback(value=BitbucketFallbacks.RepositoryOnError.class)
    @GET
    public Repository get(@PathParam(value="project") String var1, @PathParam(value="repo") String var2);

    @Named(value="repository:fork")
    @Documentation(value={"https://developer.atlassian.com/static/rest/bitbucket-server/latest/bitbucket-rest.html#idm45888277587248"})
    @Consumes(value={"application/json"})
    @Path(value="/projects/{project}/repos/{repo}")
    @Payload(value="%7B \"name\": \"{newRepo}\", \"project\": %7B \"key\": \"{newProject}\" %7D %7D")
    @Fallback(value=BitbucketFallbacks.RepositoryOnError.class)
    @POST
    public Repository fork(@PathParam(value="project") String var1, @PathParam(value="repo") String var2, @PayloadParam(value="newProject") String var3, @PayloadParam(value="newRepo") String var4);

    @Named(value="repository:delete")
    @Documentation(value={"https://developer.atlassian.com/static/rest/bitbucket-server/latest/bitbucket-rest.html#idm45888277567792"})
    @Consumes(value={"application/json"})
    @Path(value="/projects/{project}/repos/{repo}")
    @Fallback(value=BitbucketFallbacks.RequestStatusOnError.class)
    @ResponseParser(value=DeleteRepositoryParser.class)
    @DELETE
    public RequestStatus delete(@PathParam(value="project") String var1, @PathParam(value="repo") String var2);

    @Named(value="repository:list")
    @Documentation(value={"https://developer.atlassian.com/static/rest/bitbucket-server/latest/bitbucket-rest.html#idm45888277593152"})
    @Consumes(value={"application/json"})
    @Path(value="/projects/{project}/repos")
    @Fallback(value=BitbucketFallbacks.RepositoryPageOnError.class)
    @GET
    public RepositoryPage list(@PathParam(value="project") String var1, @Nullable @QueryParam(value="start") Integer var2, @Nullable @QueryParam(value="limit") Integer var3);

    @Named(value="repository:list-all")
    @Documentation(value={"https://docs.atlassian.com/bitbucket-server/rest/5.0.0/bitbucket-rest.html#idm45659055274784"})
    @Consumes(value={"application/json"})
    @Path(value="/repos")
    @Fallback(value=BitbucketFallbacks.RepositoryPageOnError.class)
    @GET
    public RepositoryPage listAll(@Nullable @QueryParam(value="projectname") String var1, @Nullable @QueryParam(value="name") String var2, @Nullable @QueryParam(value="permission") String var3, @Nullable @QueryParam(value="visibility") String var4, @Nullable @QueryParam(value="start") Integer var5, @Nullable @QueryParam(value="limit") Integer var6);

    @Named(value="repository:get-pullrequest-settings")
    @Documentation(value={"https://developer.atlassian.com/static/rest/bitbucket-server/5.0.0/bitbucket-rest.html#idm45659054915136"})
    @Consumes(value={"application/json"})
    @Path(value="/projects/{project}/repos/{repo}/settings/pull-requests")
    @Fallback(value=BitbucketFallbacks.PullRequestSettingsOnError.class)
    @GET
    public PullRequestSettings getPullRequestSettings(@PathParam(value="project") String var1, @PathParam(value="repo") String var2);

    @Named(value="repository:update-pullrequest-settings")
    @Documentation(value={"https://developer.atlassian.com/static/rest/bitbucket-server/5.0.0/bitbucket-rest.html#idm45659054915136"})
    @Consumes(value={"application/json"})
    @Path(value="/projects/{project}/repos/{repo}/settings/pull-requests")
    @Fallback(value=BitbucketFallbacks.PullRequestSettingsOnError.class)
    @POST
    public PullRequestSettings updatePullRequestSettings(@PathParam(value="project") String var1, @PathParam(value="repo") String var2, @BinderParam(value=BindToJsonPayload.class) CreatePullRequestSettings var3);

    @Named(value="repository:create-permissions-by-user")
    @Documentation(value={"https://developer.atlassian.com/static/rest/bitbucket-server/5.0.0/bitbucket-rest.html#idm45659054938032"})
    @Consumes(value={"application/json"})
    @Path(value="/projects/{project}/repos/{repo}/permissions/users")
    @Fallback(value=BitbucketFallbacks.RequestStatusOnError.class)
    @ResponseParser(value=RequestStatusParser.class)
    @PUT
    public RequestStatus createPermissionsByUser(@PathParam(value="project") String var1, @PathParam(value="repo") String var2, @QueryParam(value="permission") String var3, @QueryParam(value="name") String var4);

    @Named(value="repository:delete-permissions-by-user")
    @Documentation(value={"https://developer.atlassian.com/static/rest/bitbucket-server/5.0.0/bitbucket-rest.html#idm45659054938032"})
    @Consumes(value={"application/json"})
    @Path(value="/projects/{project}/repos/{repo}/permissions/users")
    @Fallback(value=BitbucketFallbacks.RequestStatusOnError.class)
    @ResponseParser(value=RequestStatusParser.class)
    @DELETE
    public RequestStatus deletePermissionsByUser(@PathParam(value="project") String var1, @PathParam(value="repo") String var2, @QueryParam(value="name") String var3);

    @Named(value="repository:list-permissions-by-user")
    @Documentation(value={"https://developer.atlassian.com/static/rest/bitbucket-server/5.0.0/bitbucket-rest.html#idm45659054938032"})
    @Consumes(value={"application/json"})
    @Path(value="/projects/{project}/repos/{repo}/permissions/users")
    @Fallback(value=BitbucketFallbacks.PermissionsPageOnError.class)
    @GET
    public PermissionsPage listPermissionsByUser(@PathParam(value="project") String var1, @PathParam(value="repo") String var2, @Nullable @QueryParam(value="start") Integer var3, @Nullable @QueryParam(value="limit") Integer var4);

    @Named(value="repository:create-permissions-by-group")
    @Documentation(value={"https://developer.atlassian.com/static/rest/bitbucket-server/5.0.0/bitbucket-rest.html#idm45659054969200"})
    @Consumes(value={"application/json"})
    @Path(value="/projects/{project}/repos/{repo}/permissions/groups")
    @Fallback(value=BitbucketFallbacks.RequestStatusOnError.class)
    @ResponseParser(value=RequestStatusParser.class)
    @PUT
    public RequestStatus createPermissionsByGroup(@PathParam(value="project") String var1, @PathParam(value="repo") String var2, @QueryParam(value="permission") String var3, @QueryParam(value="name") String var4);

    @Named(value="repository:delete-permissions-by-group")
    @Documentation(value={"https://developer.atlassian.com/static/rest/bitbucket-server/5.0.0/bitbucket-rest.html#idm45659054969200"})
    @Consumes(value={"application/json"})
    @Path(value="/projects/{project}/repos/{repo}/permissions/groups")
    @Fallback(value=BitbucketFallbacks.RequestStatusOnError.class)
    @ResponseParser(value=RequestStatusParser.class)
    @DELETE
    public RequestStatus deletePermissionsByGroup(@PathParam(value="project") String var1, @PathParam(value="repo") String var2, @QueryParam(value="name") String var3);

    @Named(value="repository:list-permissions-by-group")
    @Documentation(value={"https://developer.atlassian.com/static/rest/bitbucket-server/5.0.0/bitbucket-rest.html#idm45659054969200"})
    @Consumes(value={"application/json"})
    @Path(value="/projects/{project}/repos/{repo}/permissions/groups")
    @Fallback(value=BitbucketFallbacks.PermissionsPageOnError.class)
    @GET
    public PermissionsPage listPermissionsByGroup(@PathParam(value="project") String var1, @PathParam(value="repo") String var2, @Nullable @QueryParam(value="start") Integer var3, @Nullable @QueryParam(value="limit") Integer var4);
}

