/*
 * Decompiled with CFR 0.152.
 */
package com.cdancy.bitbucket.rest.features;

import com.cdancy.bitbucket.rest.annotations.Documentation;
import com.cdancy.bitbucket.rest.domain.common.RequestStatus;
import com.cdancy.bitbucket.rest.domain.project.Project;
import com.cdancy.bitbucket.rest.domain.project.ProjectPage;
import com.cdancy.bitbucket.rest.domain.project.ProjectPermissionsPage;
import com.cdancy.bitbucket.rest.fallbacks.BitbucketFallbacks;
import com.cdancy.bitbucket.rest.filters.BitbucketAuthenticationFilter;
import com.cdancy.bitbucket.rest.options.CreateProject;
import com.cdancy.bitbucket.rest.parsers.RequestStatusParser;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.binders.BindToJsonPayload;

@Produces(value={"application/json"})
@RequestFilters(value={BitbucketAuthenticationFilter.class})
@Path(value="/rest/api/{jclouds.api-version}/projects")
public interface ProjectApi {
    @Named(value="project:create")
    @Documentation(value={"https://developer.atlassian.com/static/rest/bitbucket-server/latest/bitbucket-rest.html#idm45888277995712"})
    @Consumes(value={"application/json"})
    @Fallback(value=BitbucketFallbacks.ProjectOnError.class)
    @POST
    public Project create(@BinderParam(value=BindToJsonPayload.class) CreateProject var1);

    @Named(value="project:get")
    @Documentation(value={"https://developer.atlassian.com/static/rest/bitbucket-server/latest/bitbucket-rest.html#idm45888277922400"})
    @Consumes(value={"application/json"})
    @Path(value="/{project}")
    @Fallback(value=BitbucketFallbacks.ProjectOnError.class)
    @GET
    public Project get(@PathParam(value="project") String var1);

    @Named(value="project:delete")
    @Documentation(value={"https://developer.atlassian.com/static/rest/bitbucket-server/latest/bitbucket-rest.html#idm45888277932528"})
    @Consumes(value={"application/json"})
    @Path(value="/{project}")
    @Fallback(value=BitbucketFallbacks.RequestStatusOnError.class)
    @ResponseParser(value=RequestStatusParser.class)
    @DELETE
    public RequestStatus delete(@PathParam(value="project") String var1);

    @Named(value="project:list")
    @Documentation(value={"https://developer.atlassian.com/static/rest/bitbucket-server/latest/bitbucket-rest.html#idm45888277975392"})
    @Consumes(value={"application/json"})
    @Fallback(value=BitbucketFallbacks.ProjectPageOnError.class)
    @GET
    public ProjectPage list(@Nullable @QueryParam(value="name") String var1, @Nullable @QueryParam(value="permission") String var2, @Nullable @QueryParam(value="start") Integer var3, @Nullable @QueryParam(value="limit") Integer var4);

    @Named(value="project:create-permissions-by-user")
    @Documentation(value={"https://developer.atlassian.com/static/rest/bitbucket-server/5.0.0/bitbucket-rest.html#idm45659054938032"})
    @Consumes(value={"application/json"})
    @Path(value="/{project}/permissions/users")
    @Fallback(value=BitbucketFallbacks.RequestStatusOnError.class)
    @ResponseParser(value=RequestStatusParser.class)
    @PUT
    public RequestStatus createPermissionsByUser(@PathParam(value="project") String var1, @QueryParam(value="permission") String var2, @QueryParam(value="name") String var3);

    @Named(value="project:delete-permissions-by-user")
    @Documentation(value={"https://developer.atlassian.com/static/rest/bitbucket-server/5.0.0/bitbucket-rest.html#idm45659054938032"})
    @Consumes(value={"application/json"})
    @Path(value="/{project}/permissions/users")
    @Fallback(value=BitbucketFallbacks.RequestStatusOnError.class)
    @ResponseParser(value=RequestStatusParser.class)
    @DELETE
    public RequestStatus deletePermissionsByUser(@PathParam(value="project") String var1, @QueryParam(value="name") String var2);

    @Named(value="project:list-permissions-by-user")
    @Documentation(value={"https://developer.atlassian.com/static/rest/bitbucket-server/5.0.0/bitbucket-rest.html#idm45659054938032"})
    @Consumes(value={"application/json"})
    @Path(value="/{project}/permissions/users")
    @Fallback(value=BitbucketFallbacks.ProjectPermissionsPageOnError.class)
    @GET
    public ProjectPermissionsPage listPermissionsByUser(@PathParam(value="project") String var1, @Nullable @QueryParam(value="start") Integer var2, @Nullable @QueryParam(value="limit") Integer var3);

    @Named(value="project:create-permissions-by-group")
    @Documentation(value={"https://developer.atlassian.com/static/rest/bitbucket-server/5.0.0/bitbucket-rest.html#idm45659054969200"})
    @Consumes(value={"application/json"})
    @Path(value="/{project}/permissions/groups")
    @Fallback(value=BitbucketFallbacks.RequestStatusOnError.class)
    @ResponseParser(value=RequestStatusParser.class)
    @PUT
    public RequestStatus createPermissionsByGroup(@PathParam(value="project") String var1, @QueryParam(value="permission") String var2, @QueryParam(value="name") String var3);

    @Named(value="project:delete-permissions-by-group")
    @Documentation(value={"https://developer.atlassian.com/static/rest/bitbucket-server/5.0.0/bitbucket-rest.html#idm45659054969200"})
    @Consumes(value={"application/json"})
    @Path(value="/{project}/permissions/groups")
    @Fallback(value=BitbucketFallbacks.RequestStatusOnError.class)
    @ResponseParser(value=RequestStatusParser.class)
    @DELETE
    public RequestStatus deletePermissionsByGroup(@PathParam(value="project") String var1, @QueryParam(value="name") String var2);

    @Named(value="project:list-permissions-by-group")
    @Documentation(value={"https://developer.atlassian.com/static/rest/bitbucket-server/5.0.0/bitbucket-rest.html#idm45659054969200"})
    @Consumes(value={"application/json"})
    @Path(value="/{project}/permissions/groups")
    @Fallback(value=BitbucketFallbacks.ProjectPermissionsPageOnError.class)
    @GET
    public ProjectPermissionsPage listPermissionsByGroup(@PathParam(value="project") String var1, @Nullable @QueryParam(value="start") Integer var2, @Nullable @QueryParam(value="limit") Integer var3);
}

