/*
 * Decompiled with CFR 0.152.
 */
package com.cdancy.bitbucket.rest.features;

import com.cdancy.bitbucket.rest.annotations.Documentation;
import com.cdancy.bitbucket.rest.domain.labels.Label;
import com.cdancy.bitbucket.rest.domain.labels.LabelsPage;
import com.cdancy.bitbucket.rest.fallbacks.BitbucketFallbacks;
import com.cdancy.bitbucket.rest.filters.BitbucketAuthenticationFilter;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.RequestFilters;

@Produces(value={"application/json"})
@RequestFilters(value={BitbucketAuthenticationFilter.class})
@Path(value="/rest")
public interface LabelsApi {
    @Named(value="labels:list")
    @Documentation(value={"https://docs.atlassian.com/bitbucket-server/rest/6.0.0/bitbucket-rest.html#idp86"})
    @Consumes(value={"application/json"})
    @Path(value="/api/{jclouds.api-version}/labels")
    @Fallback(value=BitbucketFallbacks.LabelsOnError.class)
    @GET
    public LabelsPage list(@Nullable @QueryParam(value="prefix") String var1);

    @Named(value="labels:get-by-name")
    @Documentation(value={"https://docs.atlassian.com/bitbucket-server/rest/6.0.0/bitbucket-rest.html#idp88"})
    @Consumes(value={"application/json"})
    @Path(value="/api/{jclouds.api-version}/labels/{labelName}")
    @Fallback(value=BitbucketFallbacks.LabelByNameOnError.class)
    @GET
    public Label getLabelByName(@PathParam(value="labelName") String var1);
}

