/*
 * Decompiled with CFR 0.152.
 */
package com.cdancy.bitbucket.rest.features;

import com.cdancy.bitbucket.rest.annotations.Documentation;
import com.cdancy.bitbucket.rest.domain.commit.Commit;
import com.cdancy.bitbucket.rest.domain.file.FilesPage;
import com.cdancy.bitbucket.rest.domain.file.LastModified;
import com.cdancy.bitbucket.rest.domain.file.LinePage;
import com.cdancy.bitbucket.rest.domain.file.RawContent;
import com.cdancy.bitbucket.rest.fallbacks.BitbucketFallbacks;
import com.cdancy.bitbucket.rest.filters.BitbucketAuthenticationFilter;
import com.cdancy.bitbucket.rest.filters.ScrubNullFromPathFilter;
import com.cdancy.bitbucket.rest.parsers.RawContentParser;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.PartParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;

@RequestFilters(value={BitbucketAuthenticationFilter.class})
public interface FileApi {
    @Named(value="file:raw-content")
    @Documentation(value={"https://jira.atlassian.com/browse/BSERV-4036"})
    @Produces(value={"application/json"})
    @Consumes(value={"text/plain"})
    @Path(value="/projects/{project}/repos/{repo}/raw/{filePath}")
    @Fallback(value=BitbucketFallbacks.RawContentOnError.class)
    @ResponseParser(value=RawContentParser.class)
    @GET
    public RawContent raw(@PathParam(value="project") String var1, @PathParam(value="repo") String var2, @PathParam(value="filePath") String var3, @Nullable @QueryParam(value="at") String var4);

    @Named(value="file:list-lines")
    @Documentation(value={"https://developer.atlassian.com/static/rest/bitbucket-server/5.1.0/bitbucket-rest.html#idm45588158357840"})
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="/rest/api/{jclouds.api-version}/projects/{project}/repos/{repo}/browse/{filePath}")
    @Fallback(value=BitbucketFallbacks.LinePageOnError.class)
    @GET
    public LinePage listLines(@PathParam(value="project") String var1, @PathParam(value="repo") String var2, @PathParam(value="filePath") String var3, @Nullable @QueryParam(value="at") String var4, @Nullable @QueryParam(value="type") Boolean var5, @Nullable @QueryParam(value="blame") Boolean var6, @Nullable @QueryParam(value="noContent") Boolean var7, @Nullable @QueryParam(value="start") Integer var8, @Nullable @QueryParam(value="limit") Integer var9);

    @Named(value="file:update-content")
    @Documentation(value={"https://docs.atlassian.com/bitbucket-server/rest/6.0.0/bitbucket-rest.html#idp185"})
    @Consumes(value={"application/json"})
    @Path(value="/rest/api/{jclouds.api-version}/projects/{project}/repos/{repo}/browse/{filePath}")
    @Fallback(value=BitbucketFallbacks.CommitOnError.class)
    @PUT
    public Commit updateContent(@PathParam(value="project") String var1, @PathParam(value="repo") String var2, @PathParam(value="filePath") String var3, @FormParam(value="branch") String var4, @PartParam(name="content") String var5, @Nullable @FormParam(value="message") String var6, @Nullable @FormParam(value="sourceCommitId") String var7, @Nullable @FormParam(value="sourceBranch") String var8);

    @Named(value="file:list-files")
    @RequestFilters(value={ScrubNullFromPathFilter.class})
    @Documentation(value={"https://docs.atlassian.com/bitbucket-server/rest/6.0.0/bitbucket-rest.html#idp222"})
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="/rest/api/{jclouds.api-version}/projects/{project}/repos/{repo}/files/{path}")
    @Fallback(value=BitbucketFallbacks.FilesPageOnError.class)
    @GET
    public FilesPage listFiles(@PathParam(value="project") String var1, @PathParam(value="repo") String var2, @Nullable @PathParam(value="path") String var3, @Nullable @QueryParam(value="at") String var4, @Nullable @QueryParam(value="start") Integer var5, @Nullable @QueryParam(value="limit") Integer var6);

    @Named(value="file:last-modified")
    @RequestFilters(value={ScrubNullFromPathFilter.class})
    @Documentation(value={"https://docs.atlassian.com/bitbucket-server/rest/6.0.0/bitbucket-rest.html#idp233"})
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="/rest/api/{jclouds.api-version}/projects/{project}/repos/{repo}/last-modified/{path}")
    @Fallback(value=BitbucketFallbacks.LastModifiedOnError.class)
    @GET
    public LastModified lastModified(@PathParam(value="project") String var1, @PathParam(value="repo") String var2, @Nullable @PathParam(value="path") String var3, @QueryParam(value="at") String var4);
}

