/*
 * Decompiled with CFR 0.152.
 */
package com.cdancy.bitbucket.rest.features;

import com.cdancy.bitbucket.rest.annotations.Documentation;
import com.cdancy.bitbucket.rest.domain.common.RequestStatus;
import com.cdancy.bitbucket.rest.domain.defaultreviewers.Condition;
import com.cdancy.bitbucket.rest.fallbacks.BitbucketFallbacks;
import com.cdancy.bitbucket.rest.filters.BitbucketAuthenticationFilter;
import com.cdancy.bitbucket.rest.options.CreateCondition;
import com.cdancy.bitbucket.rest.parsers.RequestStatusParser;
import java.util.List;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.binders.BindToJsonPayload;

@Produces(value={"application/json"})
@RequestFilters(value={BitbucketAuthenticationFilter.class})
@Path(value="/rest/default-reviewers/{jclouds.api-version}/projects")
public interface DefaultReviewersApi {
    @Named(value="default-reviewers:list-conditions")
    @Documentation(value={"https://developer.atlassian.com/static/rest/bitbucket-server/latest/bitbucket-default-reviewers-rest.html#idm46188393150720"})
    @Consumes(value={"application/json"})
    @Path(value="/{project}/repos/{repo}/conditions")
    @GET
    public List<Condition> listConditions(@PathParam(value="project") String var1, @PathParam(value="repo") String var2);

    @Named(value="default-reviewers:create-condition")
    @Documentation(value={"https://developer.atlassian.com/static/rest/bitbucket-server/latest/bitbucket-default-reviewers-rest.html#idm46188393242752"})
    @Consumes(value={"application/json"})
    @Path(value="/{project}/repos/{repo}/condition")
    @Fallback(value=BitbucketFallbacks.ConditionOnError.class)
    @POST
    public Condition createCondition(@PathParam(value="project") String var1, @PathParam(value="repo") String var2, @BinderParam(value=BindToJsonPayload.class) CreateCondition var3);

    @Named(value="default-reviewers:update-condition")
    @Documentation(value={"https://developer.atlassian.com/static/rest/bitbucket-server/latest/bitbucket-default-reviewers-rest.html#idm46188393163680"})
    @Consumes(value={"application/json"})
    @Path(value="/{project}/repos/{repo}/condition/{id}")
    @Fallback(value=BitbucketFallbacks.ConditionOnError.class)
    @PUT
    public Condition updateCondition(@PathParam(value="project") String var1, @PathParam(value="repo") String var2, @PathParam(value="id") long var3, @BinderParam(value=BindToJsonPayload.class) CreateCondition var5);

    @Named(value="default-reviewers:delete-condition")
    @Documentation(value={"https://developer.atlassian.com/static/rest/bitbucket-server/latest/bitbucket-default-reviewers-rest.html#idm46188393163680"})
    @Consumes(value={"application/json"})
    @Path(value="/{project}/repos/{repo}/condition/{id}")
    @Fallback(value=BitbucketFallbacks.RequestStatusOnError.class)
    @ResponseParser(value=RequestStatusParser.class)
    @DELETE
    public RequestStatus deleteCondition(@PathParam(value="project") String var1, @PathParam(value="repo") String var2, @PathParam(value="id") long var3);
}

