/*
 * Decompiled with CFR 0.152.
 */
package com.bw.jtools.io;

import com.bw.jtools.Log;
import java.awt.Rectangle;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonBuilderFactory;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonReader;
import javax.json.JsonString;
import javax.json.JsonValue;
import javax.json.JsonWriter;
import javax.json.JsonWriterFactory;
import javax.json.stream.JsonGeneratorFactory;

public final class JsonTool {
    private static JsonWriterFactory jsonWriterFactory_ = null;
    private static JsonWriterFactory jsonWriterFactoryNonePretty_ = null;
    private static JsonGeneratorFactory jsonGeneratorFactory = null;
    private static JsonBuilderFactory jsonBuilderFactory_ = null;
    private static Map<String, Object> jsonDefaultConfig_ = null;

    public static synchronized void setJsonConfiguration(Map<String, Object> config) {
        jsonDefaultConfig_ = config;
        jsonBuilderFactory_ = null;
        jsonWriterFactory_ = null;
        jsonGeneratorFactory = null;
    }

    public static synchronized Map<String, Object> getJsonConfiguration() {
        if (jsonDefaultConfig_ == null) {
            jsonDefaultConfig_ = new HashMap<String, Object>();
            jsonDefaultConfig_.put("javax.json.stream.JsonGenerator.prettyPrinting", Boolean.TRUE);
        }
        return jsonDefaultConfig_;
    }

    public static synchronized JsonGeneratorFactory getJsonGeneratorFactory() {
        if (jsonGeneratorFactory == null) {
            jsonGeneratorFactory = Json.createGeneratorFactory(JsonTool.getJsonConfiguration());
        }
        return jsonGeneratorFactory;
    }

    public static synchronized JsonWriterFactory getJsonWriterFactory() {
        if (jsonWriterFactory_ == null) {
            jsonWriterFactory_ = Json.createWriterFactory(JsonTool.getJsonConfiguration());
        }
        return jsonWriterFactory_;
    }

    public static synchronized JsonWriterFactory getJsonWriterFactory(boolean pretty) {
        if (pretty) {
            return JsonTool.getJsonWriterFactory();
        }
        if (jsonWriterFactoryNonePretty_ == null) {
            HashMap jsonSimpleConfig = new HashMap();
            jsonWriterFactoryNonePretty_ = Json.createWriterFactory(jsonSimpleConfig);
        }
        return jsonWriterFactoryNonePretty_;
    }

    public static synchronized JsonBuilderFactory getJsonBuilderFactory() {
        if (jsonBuilderFactory_ == null) {
            jsonBuilderFactory_ = Json.createBuilderFactory(JsonTool.getJsonConfiguration());
        }
        return jsonBuilderFactory_;
    }

    public static JsonObject readJson(File jsonFile) throws FileNotFoundException {
        JsonReader jsonReader = Json.createReader((Reader)new FileReader(jsonFile));
        return jsonReader.readObject();
    }

    public static JsonObject getJsonObject(JsonValue value, String name) {
        if (value instanceof JsonObject) {
            JsonObject object = (JsonObject)value;
            try {
                return object.getJsonObject(name);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static JsonNumber getJsonNumber(JsonValue value, String name) {
        try {
            if (value instanceof JsonObject) {
                return ((JsonObject)value).getJsonNumber(name);
            }
            if (value instanceof JsonNumber) {
                return (JsonNumber)value;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static boolean getJsonBoolean(JsonValue value, String name, boolean defaultVal) {
        try {
            if (value instanceof JsonObject) {
                return ((JsonObject)value).getBoolean(name, defaultVal);
            }
            if (value instanceof JsonNumber) {
                return ((JsonNumber)value).intValue() != 0;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return defaultVal;
    }

    public static int getJsonInt(JsonValue value, String name, int defaultVal) {
        JsonNumber nb = JsonTool.getJsonNumber(value, name);
        return nb != null ? nb.intValue() : defaultVal;
    }

    public static long getJsonLong(JsonValue value, String name, long defaultVal) {
        JsonNumber nb = JsonTool.getJsonNumber(value, name);
        return nb != null ? nb.longValue() : defaultVal;
    }

    public static String getJsonString(JsonValue value, String name) {
        if (value instanceof JsonObject) {
            JsonObject object = (JsonObject)value;
            try {
                return object.getString(name);
            }
            catch (Exception e) {
                if (object.containsKey((Object)name)) {
                    return ((JsonValue)object.get((Object)name)).toString();
                }
            }
        } else if (value instanceof JsonString) {
            return ((JsonString)value).getString();
        }
        return null;
    }

    public static JsonValue getJsonValue(JsonValue value, String name) {
        if (value instanceof JsonObject) {
            JsonObject object = (JsonObject)value;
            try {
                return (JsonValue)object.get((Object)name);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static JsonArray getJsonArray(JsonValue value, String name) {
        if (name != null && value instanceof JsonObject) {
            JsonObject object = (JsonObject)value;
            try {
                return object.getJsonArray(name);
            }
            catch (Exception exception) {
            }
        } else if (value instanceof JsonArray) {
            return (JsonArray)value;
        }
        return null;
    }

    public static Rectangle getJsonBounds(JsonValue value, String name) {
        Rectangle bounds = null;
        JsonObject boundObj = JsonTool.getJsonObject(value, name);
        if (boundObj != null) {
            JsonNumber x = JsonTool.getJsonNumber((JsonValue)boundObj, "x");
            JsonNumber y = JsonTool.getJsonNumber((JsonValue)boundObj, "y");
            JsonNumber w = JsonTool.getJsonNumber((JsonValue)boundObj, "w");
            JsonNumber h = JsonTool.getJsonNumber((JsonValue)boundObj, "h");
            if (x != null && y != null && w != null && h != null) {
                bounds = new Rectangle(x.intValue(), y.intValue(), w.intValue(), h.intValue());
            }
        }
        return bounds;
    }

    public static void addJsonBounds(JsonObjectBuilder obj, String name, Rectangle rect) {
        if (rect != null && obj != null) {
            JsonObjectBuilder bounds = JsonTool.getJsonBuilderFactory().createObjectBuilder();
            bounds.add("x", rect.x);
            bounds.add("y", rect.y);
            bounds.add("w", rect.width);
            bounds.add("h", rect.height);
            obj.add(name, bounds);
        }
    }

    public static JsonObject parseJson(String json) {
        JsonReader jsonReader = Json.createReader((Reader)new StringReader(json));
        return jsonReader.readObject();
    }

    public static JsonArray parseJsonArray(String jsonArray) {
        JsonReader jsonReader = Json.createReader((Reader)new StringReader(jsonArray));
        return jsonReader.readArray();
    }

    public static boolean writeJson(JsonObject data, File file) {
        try {
            try (JsonWriter jsonWriter = JsonTool.getJsonWriterFactory().createWriter((Writer)new FileWriter(file));){
                jsonWriter.writeObject(data);
            }
            return true;
        }
        catch (Exception ex) {
            Log.error("Failed to write " + file, ex);
            return false;
        }
    }
}

