/*
 * Decompiled with CFR 0.152.
 */
package com.bw.jtools;

import com.bw.jtools.log.CollectorLogger;
import com.bw.jtools.log.CollectorThreadLogger;
import com.bw.jtools.log.ConsoleLogger;
import com.bw.jtools.log.Log4JLogger;
import com.bw.jtools.log.MulticastLogger;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;

public final class Log {
    public static final int NONE = 0;
    public static final int ERROR = 1;
    public static final int WARN = 2;
    public static final int INFO = 3;
    public static final int DEBUG = 4;
    public static LoggerFacade log;
    protected static final CollectorLogger collectorLog;

    public static String getRestrictedStackTrace(Throwable t, String prefix, int max_lines) {
        StringWriter sw = new StringWriter(1000);
        t.printStackTrace(new PrintWriter(sw));
        String[] lines = sw.toString().split("[\\r\\n]+");
        StringBuilder sb = new StringBuilder(2048);
        int l = 0;
        while (l < max_lines && l < lines.length) {
            if (prefix != null) {
                sb.append(prefix);
            }
            sb.append(lines[l++]).append("\n");
        }
        if (l < lines.length) {
            if (prefix != null) {
                sb.append(prefix);
            }
            sb.append("...\n");
        }
        return sb.toString();
    }

    public static void startCollectMessages(int level, boolean includeStackTraces) {
        collectorLog.setThreadLog(new CollectorThreadLogger(level, includeStackTraces ? 10 : 0));
        log = MulticastLogger.addLogger(log, collectorLog);
    }

    public static void stopCollectMessages(List<String> messages) {
        CollectorThreadLogger tlog = collectorLog.getThreadLog();
        collectorLog.setThreadLog(null);
        if (!collectorLog.hasThreadLog()) {
            log = MulticastLogger.removeLogger(log, collectorLog);
        }
        if (messages != null && tlog != null) {
            messages.addAll(tlog.messages);
            tlog.messages.clear();
        }
    }

    public static void addLogger(LoggerFacade logger) {
        log = MulticastLogger.addLogger(log, logger);
    }

    public static void removeLogger(LoggerFacade logger) {
        log = MulticastLogger.removeLogger(log, logger);
    }

    public static void setLevel(int level) {
        log.setLevel(level);
    }

    public static void error(CharSequence msg) {
        log.error(msg);
    }

    public static void error(CharSequence msg, Throwable t) {
        log.error(msg, t);
    }

    public static void warn(CharSequence msg) {
        log.warn(msg);
    }

    public static void warn(CharSequence msg, Throwable t) {
        log.warn(msg, t);
    }

    public static void info(CharSequence msg) {
        log.info(msg);
    }

    public static void debug(CharSequence msg) {
        log.debug(msg);
    }

    public static void debug(CharSequence msg, Throwable t) {
        log.debug(msg, t);
    }

    public static boolean isDebugEnabled() {
        return log.isDebugEnabled();
    }

    public static boolean isInfoEnabled() {
        return log.isInfoEnabled();
    }

    public static boolean isWarnEnabled() {
        return log.isWarnEnabled();
    }

    public static boolean isErrorEnabled() {
        return log.isErrorEnabled();
    }

    static {
        try {
            log = MulticastLogger.addLogger(null, new Log4JLogger());
        }
        catch (NoClassDefFoundError ignored) {
            log = MulticastLogger.addLogger(null, new ConsoleLogger());
            log.debug("Log4J2 is not available. Logging to console.", ignored);
        }
        collectorLog = new CollectorLogger();
    }

    public static abstract class LoggerFacade {
        protected int maxStackTraceLines = 10;
        protected int level = 1;
        protected static final String DEBUG_PREFIX = "[DBG]";
        protected static final String INFO_PREFIX = "[INF]";
        protected static final String WARN_PREFIX = "[WRN]";
        protected static final String ERROR_PREFIX = "[ERR]";
        protected static final String UNKNW_PREFIX = "";

        public static String getLevelPrefix(int level) {
            switch (level) {
                case 1: {
                    return ERROR_PREFIX;
                }
                case 2: {
                    return WARN_PREFIX;
                }
                case 3: {
                    return INFO_PREFIX;
                }
                case 4: {
                    return DEBUG_PREFIX;
                }
            }
            return UNKNW_PREFIX;
        }

        public void setLevel(int level) {
            this.level = level;
        }

        public int getLevel() {
            return this.level;
        }

        public void setMaximumLinesOfStackTrace(int maxLines) {
            this.maxStackTraceLines = maxLines;
        }

        public abstract void error(CharSequence var1);

        public abstract void warn(CharSequence var1);

        public abstract void info(CharSequence var1);

        public abstract void debug(CharSequence var1);

        public void error(CharSequence msg, Throwable t) {
            if (this.level >= 1) {
                this.error(msg);
                if (t != null && this.maxStackTraceLines > 0) {
                    this.error(Log.getRestrictedStackTrace(t, " ", this.maxStackTraceLines));
                }
            }
        }

        public void warn(CharSequence msg, Throwable t) {
            if (this.level >= 2) {
                this.warn(msg);
                if (this.maxStackTraceLines > 0) {
                    this.warn(Log.getRestrictedStackTrace(t, " ", this.maxStackTraceLines));
                }
            }
        }

        public void info(CharSequence msg, Throwable t) {
            if (this.level >= 3) {
                this.info(msg);
                if (this.maxStackTraceLines > 0) {
                    this.info(Log.getRestrictedStackTrace(t, " ", this.maxStackTraceLines));
                }
            }
        }

        public void debug(CharSequence msg, Throwable t) {
            if (this.level >= 4) {
                this.debug(msg);
                if (this.maxStackTraceLines > 0) {
                    this.debug(Log.getRestrictedStackTrace(t, " ", this.maxStackTraceLines));
                }
            }
        }

        public boolean isDebugEnabled() {
            return this.level >= 4;
        }

        public boolean isInfoEnabled() {
            return this.level >= 3;
        }

        public boolean isWarnEnabled() {
            return this.level >= 2;
        }

        public boolean isErrorEnabled() {
            return this.level >= 1;
        }
    }
}

