/*
 * Decompiled with CFR 0.152.
 */
package io.github.brightyoyo;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.os.Build;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import io.github.brightyoyo.R;
import io.github.brightyoyo.utils.MetricsConverter;

public class IndexBar
extends View {
    public static final int STATE_NORMAL = 0;
    public static final int STATE_PRESSED = 1;
    private static final String LOG_TAG = "IndexBar";
    private static final int INVALID_SECTION_INDEX = -1;
    protected final Paint paint = new Paint(1);
    private int mState = 0;
    private int mIndexBarColorNormal = 0;
    private int mIndexBarColorPressed = -7829368;
    private int mAlphabetTextColor = -16777216;
    private float mAlphabetTextSize = MetricsConverter.dpToPx(this.getContext(), 10.0f);
    private float mAlphabetPadding;
    private float mIndexBarSides = this.mAlphabetPadding = MetricsConverter.dpToPx(this.getContext(), 5.0f);
    private float mIndexBarRound = MetricsConverter.dpToPx(this.getContext(), 0.0f);
    private boolean mWithinIndexBar = false;
    private String[] mSections = new String[0];
    private IIndexBarFilter mIndexBarFilter;
    private boolean mIsIndexing;
    private int mCurrentSectionPosition;

    public IndexBar(Context context) {
        super(context);
        this.initIndexBar();
    }

    public IndexBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initIndexBar(context, attrs, 0, 0);
    }

    public IndexBar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initIndexBar(context, attrs, defStyleAttr, 0);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        ViewGroup.LayoutParams lp = this.getLayoutParams();
        int margin = 0;
        if (lp instanceof ViewGroup.MarginLayoutParams) {
            ViewGroup.MarginLayoutParams mlp = (ViewGroup.MarginLayoutParams)lp;
            margin = mlp.topMargin + mlp.bottomMargin;
        }
        if (heightMode == 0x40000000) {
            int length = this.mSections.length;
            this.mAlphabetPadding = ((float)heightSize - (float)length * this.mAlphabetTextSize - (float)margin) / (float)(length + 1);
            this.setMeasuredDimension(widthMeasureSpec, heightMeasureSpec);
        } else {
            this.setMeasuredDimension(this.calculateMeasuredWidth(), this.calculateMeasureHeight());
        }
    }

    private int calculateMeasuredWidth() {
        int measuredWidth = (int)(this.getAlphabetTextSize() + this.getIndexBarSides() * 2.0f);
        Log.v((String)LOG_TAG, (String)("Calculated measured width = " + measuredWidth));
        return measuredWidth;
    }

    private int calculateMeasureHeight() {
        int length = this.mSections.length;
        float measureHeight = (float)length * this.getAlphabetTextSize() + (float)(length + 1) * this.getAlphabetPadding();
        return (int)measureHeight;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        Log.v((String)LOG_TAG, (String)"Index Bar onDraw called");
        this.drawRect(canvas);
        this.drawSections(canvas);
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouchEvent(MotionEvent event) {
        super.onTouchEvent(event);
        int action = event.getAction();
        switch (action) {
            case 0: {
                if (!this.contains(event.getX(), event.getY())) break;
                this.mIsIndexing = true;
                this.filterListItem(event.getY());
                this.setState(1);
                return true;
            }
            case 2: {
                if (!this.mIsIndexing) break;
                if (this.mWithinIndexBar) {
                    if (this.contains(event.getX(), event.getY())) {
                        this.filterListItem(event.getY());
                        break;
                    }
                    this.mIsIndexing = false;
                    this.mCurrentSectionPosition = -1;
                    this.setState(0);
                    if (this.mIndexBarFilter != null) {
                        this.mIndexBarFilter.filterList(0.0f, this.mCurrentSectionPosition, null);
                    }
                    return true;
                }
                this.filterListItem(event.getY());
                return true;
            }
            case 1: {
                if (!this.mIsIndexing) break;
                this.mIsIndexing = false;
                this.mCurrentSectionPosition = -1;
                this.setState(0);
                if (this.mIndexBarFilter != null) {
                    this.mIndexBarFilter.filterList(0.0f, this.mCurrentSectionPosition, null);
                }
                return true;
            }
        }
        return false;
    }

    private boolean contains(float y) {
        return y >= 0.0f && y <= (float)this.getHeight();
    }

    private boolean contains(float x, float y) {
        return x >= 0.0f && y >= 0.0f && x <= (float)this.getWidth() && y <= (float)this.getHeight();
    }

    private void filterListItem(float sideIndexY) {
        this.mCurrentSectionPosition = (int)((sideIndexY - this.mAlphabetPadding) / (((float)this.getMeasuredHeight() - 2.0f * this.mAlphabetPadding) / (float)this.mSections.length));
        if (this.mCurrentSectionPosition >= 0 && this.mCurrentSectionPosition < this.mSections.length) {
            Log.d((String)LOG_TAG, (String)("CurrentSectionPosition:" + this.mCurrentSectionPosition));
            String previewText = this.mSections[this.mCurrentSectionPosition];
            if (this.mIndexBarFilter != null) {
                this.mIndexBarFilter.filterList(sideIndexY, this.mCurrentSectionPosition, previewText);
            }
        }
    }

    private void initIndexBar() {
        this.initLayerType();
        Log.v((String)LOG_TAG, (String)"Index Bar initialized");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initIndexBar(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        this.initLayerType();
        TypedArray attributes = context.getTheme().obtainStyledAttributes(attrs, R.styleable.IndexBar, defStyleAttr, defStyleRes);
        try {
            this.initIndexBarColor(attributes);
            this.initIndexBarColorPressed(attributes);
            this.initAlphabetTextColor(attributes);
            this.initAlphabetTextSize(attributes);
            this.initAlphabetPadding(attributes);
            this.initIndexBarSides(attributes);
            this.initIndexBarRound(attributes);
            this.initWithinIndexBar(attributes);
        }
        catch (Exception e) {
            Log.e((String)LOG_TAG, (String)"Unable to read attr", (Throwable)e);
        }
        finally {
            attributes.recycle();
        }
    }

    private void initWithinIndexBar(TypedArray attributes) {
        if (attributes.hasValue(R.styleable.IndexBar_withinIndexBar)) {
            this.mWithinIndexBar = attributes.getBoolean(R.styleable.IndexBar_withinIndexBar, this.mWithinIndexBar);
            Log.v((String)LOG_TAG, (String)("Initialized Within Index Bar: " + this.getWithinIndexBar()));
        }
    }

    private void initAlphabetPadding(TypedArray attributes) {
        if (attributes.hasValue(R.styleable.IndexBar_alphabetPadding)) {
            this.mAlphabetPadding = attributes.getDimension(R.styleable.IndexBar_alphabetPadding, this.mAlphabetPadding);
            Log.v((String)LOG_TAG, (String)("Initialized Alphabet Offset: " + this.getAlphabetPadding()));
        }
    }

    private void initIndexBarSides(TypedArray attributes) {
        if (attributes.hasValue(R.styleable.IndexBar_indexBarSides)) {
            this.mIndexBarSides = attributes.getDimension(R.styleable.IndexBar_indexBarSides, this.mIndexBarSides);
            Log.v((String)LOG_TAG, (String)("Initialized Alphabet Offset: " + this.getIndexBarSides()));
        }
    }

    private void initAlphabetTextSize(TypedArray attributes) {
        if (attributes.hasValue(R.styleable.IndexBar_alphabetTextSize)) {
            this.mAlphabetTextSize = attributes.getDimension(R.styleable.IndexBar_alphabetTextSize, this.mAlphabetTextSize);
            Log.v((String)LOG_TAG, (String)("Initialized Alphabet TextSize: " + this.getAlphabetTextSize()));
        }
    }

    private void initAlphabetTextColor(TypedArray attributes) {
        if (attributes.hasValue(R.styleable.IndexBar_alphabetTextColor)) {
            this.mAlphabetTextColor = attributes.getColor(R.styleable.IndexBar_alphabetTextColor, this.mAlphabetTextColor);
            Log.v((String)LOG_TAG, (String)("Initialized Alphabet TextColor: " + this.getAlphabetTextColor()));
        }
    }

    private void initIndexBarColorPressed(TypedArray attributes) {
        if (attributes.hasValue(R.styleable.IndexBar_indexBarColorPressed)) {
            this.mIndexBarColorPressed = attributes.getColor(R.styleable.IndexBar_indexBarColorPressed, this.mIndexBarColorPressed);
            Log.v((String)LOG_TAG, (String)("Initialized Index Bar Color Pressed: " + this.getIndexBarColorPressed()));
        }
    }

    private void initIndexBarColor(TypedArray attributes) {
        if (attributes.hasValue(R.styleable.IndexBar_indexBarColorNormal)) {
            this.mIndexBarColorNormal = attributes.getColor(R.styleable.IndexBar_indexBarColorNormal, this.mIndexBarColorNormal);
            Log.v((String)LOG_TAG, (String)("Initialized Index Bar Color: " + this.getIndexBarColor()));
        }
    }

    private void initIndexBarRound(TypedArray attributes) {
        if (attributes.hasValue(R.styleable.IndexBar_indexBarRound)) {
            this.mIndexBarRound = attributes.getDimension(R.styleable.IndexBar_indexBarRound, this.mIndexBarRound);
            Log.v((String)LOG_TAG, (String)("Initialized Index Bar Color: " + this.getIndexBarRound()));
        }
    }

    @TargetApi(value=11)
    private void initLayerType() {
        if (Build.VERSION.SDK_INT >= 11) {
            this.setLayerType(1, this.paint);
            Log.v((String)LOG_TAG, (String)"Layer type initialized");
        }
    }

    private void drawRect(Canvas canvas) {
        this.resetPaint();
        this.paint.setStyle(Paint.Style.FILL);
        this.paint.setColor(this.getState() == 0 ? this.getIndexBarColor() : this.getIndexBarColorPressed());
        float l = 0.0f;
        float t = 0.0f;
        float r = l + (float)this.getWidth();
        float b = t + (float)this.getHeight();
        RectF rectF = new RectF(l, t, r, b);
        if (this.hasRound()) {
            canvas.drawRoundRect(rectF, this.mIndexBarRound, this.mIndexBarRound, this.paint);
        } else {
            canvas.drawRect(rectF, this.paint);
        }
    }

    private void drawSections(Canvas canvas) {
        if (this.mSections == null || this.mSections.length == 0) {
            return;
        }
        this.resetPaint();
        int length = this.mSections.length;
        float width = (float)this.getWidth() - this.mIndexBarSides * 2.0f;
        float height = ((float)this.getHeight() - (float)(length + 1) * this.mAlphabetPadding) / (float)length;
        for (int i = 0; i < length; ++i) {
            float l = this.mIndexBarSides;
            float t = (float)(i + 1) * this.mAlphabetPadding + (float)i * height;
            float r = l + width;
            float b = t + height;
            RectF targetRect = new RectF(l, t, r, b);
            this.paint.setColor(this.mAlphabetTextColor);
            this.paint.setTextAlign(Paint.Align.CENTER);
            this.paint.setTextSize(this.mAlphabetTextSize);
            Paint.FontMetricsInt fontMetrics = this.paint.getFontMetricsInt();
            float baseline = targetRect.top + (targetRect.bottom - targetRect.top - (float)fontMetrics.bottom + (float)fontMetrics.top) / 2.0f - (float)fontMetrics.top;
            canvas.drawText(this.mSections[i], targetRect.centerX(), baseline, this.paint);
        }
    }

    private boolean hasRound() {
        return this.getIndexBarRound() > 0.0f;
    }

    public int getState() {
        return this.mState;
    }

    public void setState(int state) {
        if (this.mState != state) {
            this.mState = state;
            this.invalidate();
        }
    }

    public int getIndexBarColor() {
        return this.mIndexBarColorNormal;
    }

    public void setIndexBarColorNormal(int mIndexBarColorNormal) {
        if (this.mIndexBarColorNormal != mIndexBarColorNormal) {
            this.mIndexBarColorNormal = mIndexBarColorNormal;
            this.invalidate();
        }
    }

    public int getIndexBarColorPressed() {
        return this.mIndexBarColorPressed;
    }

    public void setIndexBarColorPressed(int mIndexBarColorPressed) {
        if (this.mIndexBarColorPressed != mIndexBarColorPressed) {
            this.mIndexBarColorPressed = mIndexBarColorPressed;
            this.invalidate();
        }
    }

    public int getAlphabetTextColor() {
        return this.mAlphabetTextColor;
    }

    public void setAlphabetTextColor(int mAlphabetTextColor) {
        if (this.mAlphabetTextColor != mAlphabetTextColor) {
            this.mAlphabetTextColor = mAlphabetTextColor;
            this.invalidate();
        }
    }

    public float getAlphabetTextSize() {
        return this.mAlphabetTextSize;
    }

    public void setAlphabetTextSize(float alphabetTextSize) {
        if (this.mAlphabetTextSize != alphabetTextSize) {
            this.mAlphabetTextSize = alphabetTextSize;
            this.invalidate();
        }
    }

    public float getAlphabetPadding() {
        return this.mAlphabetPadding;
    }

    public void setAlphabetPadding(float mAlphabetPadding) {
        if (this.mAlphabetPadding != mAlphabetPadding) {
            this.mAlphabetPadding = mAlphabetPadding;
            this.invalidate();
        }
    }

    public float getIndexBarSides() {
        return this.mIndexBarSides;
    }

    public float getIndexBarRound() {
        return this.mIndexBarRound;
    }

    public void setIndexBarRound(float mIndexBarRound) {
        if (this.mIndexBarRound != mIndexBarRound) {
            this.mIndexBarRound = mIndexBarRound;
            this.invalidate();
        }
    }

    public boolean getWithinIndexBar() {
        return this.mWithinIndexBar;
    }

    public void setWithinIndexBar(boolean mWithinIndexBar) {
        if (this.mWithinIndexBar != mWithinIndexBar) {
            this.mWithinIndexBar = mWithinIndexBar;
            this.invalidate();
        }
    }

    public String[] getSections() {
        return this.mSections;
    }

    public void setSections(String[] mSections) {
        this.mSections = mSections;
        this.invalidate();
    }

    protected final void resetPaint() {
        this.paint.reset();
        this.paint.setFlags(1);
        Log.v((String)LOG_TAG, (String)"Paint reset");
    }

    public void setIndexBarFilter(IIndexBarFilter indexBarFilter) {
        this.mIndexBarFilter = indexBarFilter;
    }

    public static interface IIndexBarFilter {
        public void filterList(float var1, int var2, String var3);
    }
}

