/*
 * Decompiled with CFR 0.152.
 */
package kr.co.bootpay.android.webview;

import android.annotation.TargetApi;
import android.content.Context;
import android.os.Message;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.ConsoleMessage;
import android.webkit.GeolocationPermissions;
import android.webkit.PermissionRequest;
import android.webkit.WebChromeClient;
import android.webkit.WebView;
import android.widget.FrameLayout;
import androidx.core.content.ContextCompat;
import java.util.ArrayList;
import kr.co.bootpay.android.webview.BootpayWebView;

public class BootpayWebViewChromeClient
extends WebChromeClient {
    protected Context mContext;
    WebView mainView;

    public BootpayWebViewChromeClient(Context context) {
        this.mContext = context;
    }

    public boolean onCreateWindow(WebView view, boolean isDialog, boolean isUserGesture, Message resultMsg) {
        this.mainView = view;
        BootpayWebView newWindow = new BootpayWebView(view.getContext());
        BootpayWebView webview = (BootpayWebView)view;
        newWindow.setEventListener(webview.getEventListener());
        newWindow.setInjectedJS(webview.getInjectedJS());
        newWindow.setInjectedJSBeforePayStart(webview.getInjectedJSBeforePayStart());
        view.addView((View)newWindow, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1, 0));
        WebView.WebViewTransport transport = (WebView.WebViewTransport)resultMsg.obj;
        transport.setWebView((WebView)newWindow);
        resultMsg.sendToTarget();
        return true;
    }

    public void onCloseWindow(WebView window) {
        super.onCloseWindow(window);
        if (this.mainView != null) {
            this.mainView.removeView((View)window);
        }
        window.setVisibility(8);
    }

    public boolean onConsoleMessage(ConsoleMessage consoleMessage) {
        return true;
    }

    @TargetApi(value=21)
    public void onPermissionRequest(PermissionRequest request) {
        int i;
        String[] requestedResources = request.getResources();
        ArrayList<String> permissions = new ArrayList<String>();
        ArrayList<String> grantedPermissions = new ArrayList<String>();
        for (i = 0; i < requestedResources.length; ++i) {
            if (requestedResources[i].equals("android.webkit.resource.AUDIO_CAPTURE")) {
                permissions.add("android.permission.RECORD_AUDIO");
                continue;
            }
            if (!requestedResources[i].equals("android.webkit.resource.VIDEO_CAPTURE")) continue;
            permissions.add("android.permission.CAMERA");
        }
        for (i = 0; i < permissions.size(); ++i) {
            if (ContextCompat.checkSelfPermission((Context)this.mContext, (String)((String)permissions.get(i))) != 0) continue;
            if (((String)permissions.get(i)).equals("android.permission.RECORD_AUDIO")) {
                grantedPermissions.add("android.webkit.resource.AUDIO_CAPTURE");
                continue;
            }
            if (!((String)permissions.get(i)).equals("android.permission.CAMERA")) continue;
            grantedPermissions.add("android.webkit.resource.VIDEO_CAPTURE");
        }
        if (grantedPermissions.isEmpty()) {
            request.deny();
        } else {
            String[] grantedPermissionsArray = new String[grantedPermissions.size()];
            grantedPermissionsArray = grantedPermissions.toArray(grantedPermissionsArray);
            request.grant(grantedPermissionsArray);
        }
    }

    public void onGeolocationPermissionsShowPrompt(String origin, GeolocationPermissions.Callback callback) {
        callback.invoke(origin, true, false);
    }
}

