/*
 * Decompiled with CFR 0.152.
 */
package kr.co.bootpay.android.analytics;

import android.util.Log;
import com.google.gson.Gson;
import java.util.List;
import kr.co.bootpay.android.analytics.AnalyticsService;
import kr.co.bootpay.android.analytics.LoginResult;
import kr.co.bootpay.android.models.statistics.BootStatCall;
import kr.co.bootpay.android.models.statistics.BootStatItem;
import kr.co.bootpay.android.models.statistics.BootStatLogin;
import kr.co.bootpay.android.pref.UserInfo;
import kr.co.bootpay.android.secure.BootpaySimpleAES256;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class AnalyticsPresenter {
    AnalyticsService service;

    public AnalyticsPresenter(AnalyticsService service) {
        this.service = service;
    }

    public void userTrace(String id, String email, String username, int gender, String birth, String phone, String area) {
        BootStatLogin login = new BootStatLogin("4.0.0", UserInfo.getInstance(this.service.getContext()).getBootpayApplicationId(), id, email, username, gender, birth, phone, area);
        String json = new Gson().toJson((Object)login);
        BootpaySimpleAES256 aes = new BootpaySimpleAES256();
        Call<LoginResult> dataCall = this.service.getApi().login(aes.strEncode(json), aes.getSessionKey());
        dataCall.enqueue((Callback)new Callback<LoginResult>(){

            public void onResponse(Call<LoginResult> call, Response<LoginResult> response) {
                if (response != null && response.body() != null) {
                    if (((LoginResult)response.body()).getData() != null) {
                        UserInfo.getInstance(AnalyticsPresenter.this.service.getContext()).setBootpayUserId(((LoginResult)response.body()).getData().getUserId());
                    }
                    Log.d((String)"bootpay", (String)new Gson().toJson((Object)((LoginResult)response.body()).getData()));
                }
            }

            public void onFailure(Call<LoginResult> call, Throwable t) {
                Log.d((String)"bootpay", (String)t.getMessage());
            }
        });
    }

    public void pageTrace(String url, String page_type, List<BootStatItem> items) {
        Log.d((String)"BootpayAnalytics", (String)"onComplete");
        BootStatCall call = new BootStatCall("4.0.0", UserInfo.getInstance(this.service.getContext()).getBootpayApplicationId(), UserInfo.getInstance(this.service.getContext()).getBootpayUuid(), url, page_type, items, UserInfo.getInstance(this.service.getContext()).getBootpaySk(), UserInfo.getInstance(this.service.getContext()).getBootpayUserId(), "");
        String json = new Gson().toJson((Object)call);
        BootpaySimpleAES256 aes = new BootpaySimpleAES256();
        Call<LoginResult> dataCall = this.service.getApi().call(aes.strEncode(json), aes.getSessionKey());
        dataCall.enqueue((Callback)new Callback<LoginResult>(){

            public void onResponse(Call<LoginResult> call, Response<LoginResult> response) {
                if (response != null && response.body() != null) {
                    Log.d((String)"bootpay", (String)new Gson().toJson((Object)((LoginResult)response.body()).getData()));
                }
            }

            public void onFailure(Call<LoginResult> call, Throwable t) {
                Log.d((String)"bootpay", (String)t.getMessage());
            }
        });
    }
}

