/*
 * Decompiled with CFR 0.152.
 */
package org.socialsignin.spring.data.dynamodb.mapping.event;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.socialsignin.spring.data.dynamodb.mapping.event.AbstractDynamoDBEventListener;
import org.springframework.util.Assert;

public class ValidatingDynamoDBEventListener
extends AbstractDynamoDBEventListener<Object> {
    private static final Logger LOG = LoggerFactory.getLogger(ValidatingDynamoDBEventListener.class);
    private final Validator validator;

    public ValidatingDynamoDBEventListener(Validator validator) {
        Assert.notNull((Object)validator, (String)"validator must not be null!");
        this.validator = validator;
    }

    @Override
    public void onBeforeSave(Object source) {
        LOG.debug("Validating object: {}", source);
        ArrayList<String> messages = new ArrayList<String>();
        Set violations = this.validator.validate(source, new Class[0]);
        if (!violations.isEmpty()) {
            HashSet<ConstraintViolation> genericViolationSet = new HashSet<ConstraintViolation>();
            for (ConstraintViolation v : violations) {
                genericViolationSet.add(v);
                messages.add(v.toString());
            }
            LOG.info("During object: {} validation violations found: {}", source, (Object)violations);
            throw new ConstraintViolationException(((Object)messages).toString(), genericViolationSet);
        }
    }
}

