/*
 * Decompiled with CFR 0.152.
 */
package org.socialsignin.spring.data.dynamodb.repository.support;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.springframework.data.repository.core.support.AbstractEntityInformation;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public class FieldAndGetterReflectionEntityInformation<T, ID>
extends AbstractEntityInformation<T, ID> {
    protected Method method;
    private Field field;

    public FieldAndGetterReflectionEntityInformation(@NonNull Class<T> domainClass, @NonNull Class<? extends Annotation> annotation) {
        super(domainClass);
        Assert.notNull(annotation, (String)"annotation must not be null!");
        ReflectionUtils.doWithMethods(domainClass, method -> {
            if (method.getAnnotation(annotation) != null) {
                this.method = method;
                return;
            }
        });
        if (this.method == null) {
            this.field = null;
            ReflectionUtils.doWithFields(domainClass, field -> {
                if (field.getAnnotation(annotation) != null) {
                    this.field = field;
                    return;
                }
            });
        }
        Assert.isTrue((this.method != null || this.field != null ? 1 : 0) != 0, (String)String.format("No field or method annotated with %s found!", annotation.toString()));
        Assert.isTrue((this.method == null || this.field == null ? 1 : 0) != 0, (String)String.format("Both field and method annotated with %s found!", annotation.toString()));
        if (this.method != null) {
            ReflectionUtils.makeAccessible((Method)this.method);
        }
        if (this.field != null) {
            ReflectionUtils.makeAccessible((Field)this.field);
        }
    }

    public ID getId(T entity) {
        if (this.method != null) {
            return (ID)(entity == null ? null : ReflectionUtils.invokeMethod((Method)this.method, entity));
        }
        return (ID)(entity == null ? null : ReflectionUtils.getField((Field)this.field, entity));
    }

    public Class<ID> getIdType() {
        return this.method != null ? this.method.getReturnType() : this.field.getType();
    }
}

